/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.nooj4nlp.engine.AmbiguitiesUnambiguitiesObject;
import net.nooj4nlp.engine.Charlist;
import net.nooj4nlp.engine.Dic;
import net.nooj4nlp.engine.FSDic;
import net.nooj4nlp.engine.Gram;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Grammar;
import net.nooj4nlp.engine.Indexkey;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.MatchType;
import net.nooj4nlp.engine.Mft;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.Preferences;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.Regexp;
import net.nooj4nlp.engine.Regexps;
import net.nooj4nlp.engine.TheSolutions;
import net.nooj4nlp.engine.helper.BackgroundWorker;
import net.nooj4nlp.engine.helper.ParameterCheck;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class Engine {
    public Language Lan;
    private HashMap<String, Gram> paradigms;
    private String applicationDir;
    public String docDir;
    private String projectDir;
    private boolean projectMode;
    public boolean BackgroundWorking;
    public BackgroundWorker backgroundWorker;
    public Preferences preferences;
    public boolean ResourcesLoaded;
    HashMap<String, String> properties;
    private HashMap<String, Boolean> prop_cat;
    private HashMap<String, Boolean> prop_inf;
    private ArrayList<Object> lexBins;
    private ArrayList<Object> lexGrms;
    public ArrayList<Object> synGrms;
    transient HashMap<String, String> recursiveMorphology = null;
    private String CurrentLine;
    private Engine engine2;
    private transient HashMap<String, ArrayList<String>> lexforalldics;

    public final boolean loadResources(ArrayList<String> lexresources, ArrayList<String> synresources, boolean handlelexicongrammarpairs, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        String dname;
        String fullname;
        String lname;
        int priority;
        String prio;
        String prefname;
        errmessage.argvalue = null;
        if (lexresources == null) {
            errmessage.argvalue = "no lexical resource is provided";
            Dic.writeLog((String)errmessage.argvalue);
            return false;
        }
        for (String prefname0 : lexresources) {
            prefname = new File(prefname0).getName();
            prio = prefname.substring(0, 2);
            priority = 0;
            try {
                priority = Integer.parseInt(prio);
            }
            catch (Exception e) {
                errmessage.argvalue = "Cannot parse priority for file " + prefname;
                Dic.writeLog((String)errmessage.argvalue);
                return false;
            }
            if (this.docDir != null) {
                String dname2;
                lname = this.Lan.isoName;
                String fname = prefname.substring(2);
                if (this.projectMode) {
                    dname2 = FilenameUtils.concat(this.projectDir, FilenameUtils.concat(lname, "Lexical Analysis"));
                    if (!new File(dname2).isDirectory()) {
                        dname2 = FilenameUtils.concat(this.projectDir, lname);
                    }
                    fullname = FilenameUtils.concat(dname2, prefname);
                } else {
                    dname2 = FilenameUtils.concat(this.docDir, FilenameUtils.concat(lname, "Lexical Analysis"));
                    fullname = FilenameUtils.concat(dname2, fname);
                }
            } else {
                dname = FilenameUtils.getBaseName(FilenameUtils.getFullPathNoEndSeparator(prefname0));
                fullname = FilenameUtils.concat(dname, prefname.substring(2));
            }
            File newFile = new File(fullname);
            if (!newFile.isFile()) {
                errmessage.argvalue = "Cannot find resource file " + fullname;
                Dic.writeLog((String)errmessage.argvalue);
                return false;
            }
            String ext = FilenameUtils.getExtension(fullname);
            if (ext.equalsIgnoreCase("jnod")) {
                Grammar grm;
                String lg;
                FSDic[] dics = null;
                dics = FSDic.load(fullname, this, errmessage);
                if (dics == null) {
                    errmessage.argvalue = "Cannot load dictionary binary file " + fullname;
                    Dic.writeLog((String)errmessage.argvalue);
                    return false;
                }
                for (FSDic dic : dics) {
                    if (dic == null) continue;
                    this.lexBins.add(dic);
                    this.lexBins.add(priority);
                    if (dic.paradigms == null) continue;
                    for (String expname : dic.paradigms.keySet()) {
                        if (this.paradigms.containsKey(expname)) continue;
                        this.paradigms.put(expname, dic.paradigms.get(expname));
                    }
                }
                if (!handlelexicongrammarpairs || !new File(lg = FilenameUtils.concat(FilenameUtils.getBaseName(FilenameUtils.getFullPathNoEndSeparator(fullname)), FilenameUtils.getBaseName(fullname) + "." + "nog")).isFile() || (grm = Grammar.loadONooJGrammar(lg)) == null || grm.compileAll(this) != null) continue;
                this.synGrms.add(grm);
                this.synGrms.add(0);
                this.synGrms.add(Character.valueOf('X'));
                continue;
            }
            if (!ext.equals("nom") && !ext.equals("NOM")) continue;
            Grammar grm = null;
            boolean istextual = Grammar.isItTextual(fullname);
            if (istextual) {
                grm = Grammar.loadTextual(fullname, GramType.MORPHO, errmessage);
                if (errmessage.argvalue != null) {
                    errmessage.argvalue = "Problem in grammar " + fullname + ":\n" + (String)errmessage.argvalue;
                    Dic.writeLog((String)errmessage.argvalue);
                    return false;
                }
            } else {
                grm = Grammar.loadONooJGrammar(fullname);
            }
            if (grm == null || grm.compileAll(this) != null) continue;
            this.lexGrms.add(grm);
            this.lexGrms.add(priority);
        }
        if (synresources == null) {
            return true;
        }
        for (String prefname0 : synresources) {
            prefname = new File(prefname0).getName();
            prio = prefname.substring(0, 2);
            try {
                priority = Integer.parseInt(prio);
            }
            catch (Exception e2) {
                errmessage.argvalue = "Cannot parse order number for resource file " + prefname;
                Dic.writeLog((String)errmessage.argvalue);
                return false;
            }
            if (this.docDir != null) {
                String dname3;
                lname = this.Lan.isoName;
                if (this.projectMode) {
                    dname3 = FilenameUtils.concat(this.projectDir, FilenameUtils.concat(lname, "Syntactic Analysis"));
                    if (!new File(dname3).isDirectory()) {
                        dname3 = FilenameUtils.concat(this.projectDir, lname);
                    }
                    fullname = FilenameUtils.concat(dname3, prefname);
                } else {
                    String fname = prefname.substring(2);
                    dname3 = FilenameUtils.concat(this.docDir, FilenameUtils.concat(lname, "Syntactic Analysis"));
                    fullname = FilenameUtils.concat(dname3, fname);
                }
            } else {
                dname = FilenameUtils.getBaseName(FilenameUtils.getFullPathNoEndSeparator(prefname0));
                fullname = FilenameUtils.concat(dname, prefname.substring(2));
            }
            if (!new File(fullname).isFile()) {
                errmessage.argvalue = "Cannot find file " + fullname;
                Dic.writeLog((String)errmessage.argvalue);
                return false;
            }
            String ext = FilenameUtils.getExtension(fullname);
            String fn = FilenameUtils.getBaseName(fullname);
            char cfn = '\u0000';
            if (fn.length() > 2 && fn.charAt(fn.length() - 2) == '-') {
                cfn = fn.charAt(fn.length() - 1);
            }
            if (ext.equalsIgnoreCase("nog")) {
                Grammar grm = null;
                boolean istextual = Grammar.isItTextual(fullname);
                if (istextual) {
                    grm = Grammar.loadTextual(fullname, GramType.SYNTAX, errmessage);
                    if (errmessage.argvalue != null) {
                        return false;
                    }
                } else {
                    grm = Grammar.loadONooJGrammar(fullname);
                }
                if (grm == null || grm.compileAll(this) != null) continue;
                this.synGrms.add(grm);
                this.synGrms.add(priority);
                if (cfn == 'A') {
                    this.synGrms.add(Character.valueOf('A'));
                    continue;
                }
                if (cfn == 'S') {
                    this.synGrms.add(Character.valueOf('S'));
                    continue;
                }
                this.synGrms.add(Character.valueOf('L'));
                continue;
            }
            if (!ext.equals("nox") && !ext.equals("NOX")) continue;
            String rawBuffer = FileUtils.readFileToString(new File(fullname), "UTF-8");
            Regexp regexp = new Regexp(this.Lan, rawBuffer, GramType.SYNTAX);
            if (regexp.Grm == null) continue;
            Regexps regexps = new Regexps(this.Lan, GramType.SYNTAX, regexp.Grm, this);
            Grammar grm = regexps.grammar;
            if (grm == null) continue;
            this.synGrms.add(grm);
            this.synGrms.add(priority);
            if (cfn == 'A') {
                this.synGrms.add(Character.valueOf('A'));
                continue;
            }
            if (cfn == 'S') {
                this.synGrms.add(Character.valueOf('S'));
                continue;
            }
            this.synGrms.add(Character.valueOf('L'));
        }
        this.ResourcesLoaded = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean loadCategoryPropertiesFeatures(RefObject<String> errmessage) {
        String propertydefinitionfile;
        this.prop_inf = null;
        this.prop_cat = null;
        this.properties = null;
        errmessage.argvalue = null;
        if (this.projectMode) {
            propertydefinitionfile = FilenameUtils.concat(Paths.projectDir, FilenameUtils.concat(this.Lan.isoName, FilenameUtils.concat("Lexical Analysis", "_properties.def")));
            if (!new File(propertydefinitionfile).isFile() && !new File(propertydefinitionfile = FilenameUtils.concat(Paths.projectDir, FilenameUtils.concat(this.Lan.isoName, FilenameUtils.concat("Lexical Analysis", "properties.def")))).isFile()) {
                errmessage.argvalue = "Cannot find Property Definition File: " + propertydefinitionfile;
                Dic.writeLog((String)errmessage.argvalue);
                return false;
            }
        } else {
            propertydefinitionfile = FilenameUtils.concat(this.docDir, FilenameUtils.concat(this.Lan.isoName, FilenameUtils.concat("Lexical Analysis", "properties.def")));
            if (!new File(propertydefinitionfile).isFile() && !new File(propertydefinitionfile = FilenameUtils.concat(this.docDir, FilenameUtils.concat(this.Lan.isoName, FilenameUtils.concat("Lexical Analysis", "_properties.def")))).isFile()) {
                errmessage.argvalue = "Cannot find Property Definition File: " + propertydefinitionfile;
                Dic.writeLog((String)errmessage.argvalue);
                return false;
            }
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(propertydefinitionfile), "UTF8"));
            String header = bufferedReader.readLine();
            if (!(header.equals("# NooJ V1") || header.equals("# NooJ V2") || header.equals("# NooJ V3") || header.equals("# NooJ V4"))) {
                errmessage.argvalue = "Property Definition File Format is invalid in " + propertydefinitionfile;
                Dic.writeLog((String)errmessage.argvalue);
                boolean bl = false;
                return bl;
            }
            String rawBuffer = "";
            String line = bufferedReader.readLine();
            while (line != null) {
                rawBuffer = rawBuffer + line;
                rawBuffer = rawBuffer + "\n";
                line = bufferedReader.readLine();
            }
            String buf = Dic.noComment(rawBuffer);
            int ibuf = 0;
            while (ibuf < buf.length()) {
                int ifeat;
                String category = null;
                String property = null;
                String[] features = null;
                RefObject<Object> tempRef_category = new RefObject<Object>(category);
                RefObject<Object> tempRef_property = new RefObject<Object>(property);
                RefObject<Object> tempRef_features = new RefObject<Object>(features);
                int end = Dic.getRule(buf, ibuf, tempRef_category, tempRef_property, tempRef_features, errmessage);
                category = (String)tempRef_category.argvalue;
                property = (String)tempRef_property.argvalue;
                features = (String[])tempRef_features.argvalue;
                if (end == -1) {
                    if (errmessage.argvalue == null) return true;
                    boolean bl = false;
                    return bl;
                }
                if (category.equals("INFLECTION")) {
                    if (this.prop_inf == null) {
                        this.prop_inf = new HashMap();
                    }
                    for (ifeat = 0; ifeat < features.length; ++ifeat) {
                        if (this.prop_inf.containsKey(features[ifeat])) continue;
                        this.prop_inf.put(features[ifeat], true);
                    }
                } else {
                    if (this.prop_cat == null) {
                        this.prop_cat = new HashMap();
                    }
                    if (!this.prop_cat.containsKey(category + "_" + property)) {
                        this.prop_cat.put(category + "_" + property, true);
                    }
                    for (ifeat = 0; ifeat < features.length; ++ifeat) {
                        String ncat;
                        if (this.properties == null) {
                            this.properties = new HashMap();
                        }
                        if (this.properties.containsKey(ncat = category + "_" + features[ifeat])) continue;
                        this.properties.put(ncat, property);
                    }
                }
                ibuf = end;
            }
            return true;
        }
        catch (IOException iOException) {
            return true;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Engine(RefObject<Language> lan, String appdir, String docdir, String projdir, boolean projectmode, Preferences prefs, boolean backgroundworking, BackgroundWorker backgroundworker) {
        this.Lan = (Language)lan.argvalue;
        this.applicationDir = appdir;
        this.docDir = docdir;
        this.projectDir = projdir;
        this.projectMode = projectmode;
        this.BackgroundWorking = backgroundworking;
        this.backgroundWorker = backgroundworker;
        this.preferences = prefs;
        this.lexBins = new ArrayList();
        this.lexGrms = new ArrayList();
        this.paradigms = new HashMap();
        this.synGrms = new ArrayList();
        this.recursiveMorphology = null;
        this.engine2 = null;
        String errmessage = null;
        RefObject<Object> tempRef_errmessage = new RefObject<Object>(errmessage);
        this.loadCategoryPropertiesFeatures(tempRef_errmessage);
        errmessage = (String)tempRef_errmessage.argvalue;
        if (errmessage != null) {
            System.out.println(errmessage);
        }
        StringBuilder errmessage2t = new StringBuilder("");
        boolean tempVar = false;
        if (tempVar) {
            System.out.println(errmessage2t.toString());
        }
    }

    public final Mft delimit(Ntext text) {
        Mft mft = null;
        if (text.DelimPattern == null || text.DelimPattern.equals("")) {
            if (text.buffer.length() > 65535) {
                return null;
            }
            text.nbOfTextUnits = 1;
            mft = new Mft(1);
            mft.tuAddresses[1] = 0;
            mft.tuLengths[1] = text.buffer.length();
        } else {
            Pattern rexp = Pattern.compile(text.DelimPattern, 8);
            Matcher mc = rexp.matcher(text.buffer);
            int groupCount = 0;
            while (mc.find()) {
                ++groupCount;
            }
            mc = rexp.matcher(text.buffer);
            mft = new Mft(groupCount + 1);
            int itu = 1;
            int strt = 0;
            int len = 0;
            boolean needtoresize = false;
            while (mc.find()) {
                mc.group();
                int end = mc.start();
                len = mc.end() - end;
                boolean foundsomething = false;
                for (int i = strt; i < end; ++i) {
                    if (Character.isWhitespace(text.buffer.charAt(i))) continue;
                    foundsomething = true;
                }
                if (foundsomething) {
                    needtoresize = true;
                    mft.tuAddresses[itu] = strt;
                    mft.tuLengths[itu] = end - strt;
                    ++itu;
                }
                strt = end + len;
            }
            mft.tuAddresses[itu] = strt;
            mft.tuLengths[itu] = text.buffer.length() - strt;
            if (needtoresize) {
                mft.reSize(itu);
            }
            text.nbOfTextUnits = itu;
        }
        return mft;
    }

    public final String delimitTextUnits(Ntext mytext) {
        return mytext.delimitTextUnits(this);
    }

    public final void countChars(Ntext text, HashMap<Character, Integer> thechars) {
        for (int i = 0; i < text.buffer.length(); ++i) {
            int frq;
            char c = text.buffer.charAt(i);
            if (!thechars.containsKey(Character.valueOf(c))) {
                frq = 1;
                thechars.put(Character.valueOf(c), frq);
                continue;
            }
            frq = thechars.get(Character.valueOf(c));
            thechars.put(Character.valueOf(c), frq + 1);
        }
    }

    public final void computeAlphabet(Ntext text) {
        text.nbOfDiffChars = 0;
        text.nbOfChars = 0;
        text.nbOfDiffLetters = 0;
        text.nbOfLetters = 0;
        text.nbOfDiffDelimiters = 0;
        text.nbOfDelimiters = 0;
        text.nbOfDiffBlanks = 0;
        text.nbOfBlanks = 0;
        text.nbOfDiffDigits = 0;
        text.nbOfDigits = 0;
        HashMap<Character, Integer> thechars = new HashMap<Character, Integer>();
        this.countChars(text, thechars);
        text.charlist = new Charlist();
        for (char cc : thechars.keySet()) {
            ++text.nbOfDiffChars;
            text.nbOfChars += thechars.get(Character.valueOf(cc)).intValue();
            text.charlist.chars.add(Character.valueOf(cc));
            text.charlist.freqs.add((int)thechars.get(Character.valueOf(cc)));
            if (Language.isLetter(cc)) {
                ++text.nbOfDiffLetters;
                text.nbOfLetters += thechars.get(Character.valueOf(cc)).intValue();
                text.charlist.types.add("WFORM");
                continue;
            }
            if (Character.isWhitespace(cc)) {
                ++text.nbOfDiffBlanks;
                text.nbOfBlanks += thechars.get(Character.valueOf(cc)).intValue();
                text.charlist.types.add("WSPACE");
                continue;
            }
            if (Character.isDigit(cc)) {
                ++text.nbOfDiffDigits;
                text.nbOfDigits += thechars.get(Character.valueOf(cc)).intValue();
                text.charlist.types.add("DIGIT");
                continue;
            }
            ++text.nbOfDiffDelimiters;
            text.nbOfDelimiters += thechars.get(Character.valueOf(cc)).intValue();
            text.charlist.types.add("DELIM");
        }
    }

    private final void addToken(HashMap<String, Integer> hCorpusTokens, HashMap<String, Indexkey> hTextTokens, String token, int begaddress, int endaddress) {
        Indexkey indexkey;
        if (hTextTokens.containsKey(token)) {
            indexkey = hTextTokens.get(token);
            indexkey.addresses.add(begaddress);
            indexkey.addresses.add(endaddress);
        } else {
            indexkey = new Indexkey();
            indexkey.addresses.add(begaddress);
            indexkey.addresses.add(endaddress);
            hTextTokens.put(token, indexkey);
        }
        if (hCorpusTokens != null) {
            if (hCorpusTokens.containsKey(token)) {
                int freq = hCorpusTokens.get(token);
                hCorpusTokens.put(token, ++freq);
            } else {
                hCorpusTokens.put(token, 1);
            }
        }
    }

    public final void addLexemeToText(ArrayList<Object> annotations, HashMap<String, Integer> hTextLexemes, String lexeme, Mft textmft, int tunb, double relbegaddress, double relendaddress) {
        int tokenId;
        String entry = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        String lemma = null;
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        String category = null;
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        String[] features = null;
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        boolean tempVar = !Dic.parseDELAF(lexeme, tempRef_entry, tempRef_lemma, null, tempRef_category, null, tempRef_features);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        if (tempVar) {
            lexeme = "invalid,INVALID";
        }
        if (hTextLexemes.containsKey(lexeme)) {
            tokenId = hTextLexemes.get(lexeme);
        } else {
            annotations.add(lexeme);
            tokenId = annotations.size() - 1;
            hTextLexemes.put(lexeme, tokenId);
        }
        textmft.addTransition(tunb, relbegaddress, tokenId, relendaddress);
    }

    private final void addSyntaxToText(ArrayList<Object> annotations, ArrayList<Object> coloredtext, HashMap<String, Integer> hTextLexemes, String lexeme, Mft textmft, int tunb, double relbegaddress, double relendaddress, boolean resetannotations) {
        String entry = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        String lemma = null;
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        String category = null;
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        String[] features = null;
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        boolean tempVar = !Dic.parseDELAF(lexeme, tempRef_entry, tempRef_lemma, null, tempRef_category, null, tempRef_features);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        if (tempVar) {
            lexeme = "invalid,INVALID";
        }
        ArrayList<String> infos = Dic.normalizeInformation(category, features, this.properties);
        if (coloredtext == null) {
            coloredtext = new ArrayList();
        }
        for (String inf : infos) {
            int tokenId;
            String lex = entry + "," + lemma + "," + inf;
            String myfeature = Dic.lookFor("COLOR", lex, null);
            if (myfeature != null) {
                coloredtext.add((double)textmft.tuAddresses[tunb] + relbegaddress);
                String colorname = myfeature.substring(new String("COLOR=").length());
                Color c = colorname.equals("RED") ? Color.RED : (colorname.equals("GREEN") ? new Color(20, 180, 62) : (colorname.equals("BLUE") ? Color.BLUE : (colorname.equals("LIGHTRED") ? Color.PINK : (colorname.equals("LIGHTGREEN") ? new Color(20, 180, 62) : (colorname.equals("LIGHTBLUE") ? Color.blue : (colorname.equals("YELLOW") ? Color.YELLOW : (colorname.equals("PURPLE") ? Color.MAGENTA : (colorname.equals("CYAN") ? Color.CYAN : Color.BLACK))))))));
                coloredtext.add(c);
                coloredtext.add(relendaddress - relbegaddress);
            }
            if (hTextLexemes.containsKey(lex)) {
                tokenId = hTextLexemes.get(lex);
                textmft.addTransition(tunb, relbegaddress, tokenId, relendaddress);
                continue;
            }
            annotations.add(lex);
            tokenId = annotations.size() - 1;
            if (!hTextLexemes.containsKey(lex)) {
                hTextLexemes.put(lex, tokenId);
            }
            if (resetannotations) {
                textmft.deleteNonXrefsAndAddTransition(tunb, relbegaddress, tokenId, annotations, relendaddress);
                continue;
            }
            textmft.addTransition(tunb, relbegaddress, tokenId, relendaddress);
        }
    }

    private final void addUnknown(ArrayList<Object> annotations, HashMap<String, Integer> hCorpusUnknowns, HashMap<String, Integer> hTextUnknowns, String unknownform) {
        int tokenId;
        String lex = unknownform + ",UNKNOWN";
        if (hCorpusUnknowns != null) {
            if (hCorpusUnknowns.containsKey(lex)) {
                tokenId = hCorpusUnknowns.get(lex);
            } else {
                annotations.add(lex);
                tokenId = annotations.size() - 1;
                hCorpusUnknowns.put(lex, tokenId);
            }
        } else {
            annotations.add(lex);
            tokenId = annotations.size() - 1;
        }
        if (!hTextUnknowns.containsKey(lex)) {
            hTextUnknowns.put(lex, tokenId);
        }
    }

    public final ArrayList<String> lookup(int position, String simpletoken, boolean processconstraints, String currentline, int cpos, RefObject<String> errmessage) {
        ArrayList<String> sols = null;
        if (position == -2) {
            int i;
            ArrayList<String> ressols = null;
            errmessage.argvalue = null;
            boolean comp = false;
            if (simpletoken != null && simpletoken.length() != 0) {
                for (i = 0; i < simpletoken.length() && !comp; ++i) {
                    if (Language.isLetter(simpletoken.charAt(i))) continue;
                    comp = true;
                }
            }
            if ((sols = comp ? this.lookup(0, simpletoken, false, null, -1, errmessage) : this.lookup(-1, simpletoken, false, null, 0, errmessage)) != null) {
                ressols = new ArrayList<String>();
                for (i = 0; i < sols.size(); i += 2) {
                    String entry = null;
                    String info = null;
                    RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                    RefObject<Object> tempRef_info = new RefObject<Object>(info);
                    Dic.parseDELAS(sols.get(i), tempRef_entry, tempRef_info);
                    entry = (String)tempRef_entry.argvalue;
                    info = (String)tempRef_info.argvalue;
                    if (this.isComplex(info, null)) {
                        ArrayList<ArrayList<String>> resultingexp = this.processTokenAnalysis(1, info, simpletoken, 1, errmessage);
                        if (resultingexp == null) {
                            if (errmessage.argvalue == null) continue;
                            Dic.writeLog((String)errmessage.argvalue);
                            return null;
                        }
                        ArrayList<ArrayList<String>> defactorizedexp = new ArrayList<ArrayList<String>>();
                        Engine.recursiveDevelop(new ArrayList<String>(), resultingexp, defactorizedexp);
                        for (int iterm = 0; iterm < defactorizedexp.size(); ++iterm) {
                            ArrayList<String> sequence = defactorizedexp.get(iterm);
                            ArrayList<String> seq2 = this.getRidOfConstraintsOrAngles(sequence, 'C');
                            ArrayList<String> seq3 = this.getRidOfConstraintsOrAngles(seq2, 'A');
                            StringBuilder asol = Grammar.computeInput(seq3);
                            ressols.add(asol.toString());
                        }
                        continue;
                    }
                    ressols.add(sols.get(i));
                }
            }
            return ressols;
        }
        if (position < 0 && cpos < 0) {
            if (this.lexforalldics == null) {
                this.lexforalldics = new HashMap();
            }
            if (this.lexforalldics.containsKey(simpletoken)) {
                return this.lexforalldics.get(simpletoken);
            }
            for (int iprio = -9; iprio < 10; ++iprio) {
                if (this.lexBins == null) continue;
                for (int idic = 0; idic < this.lexBins.size(); idic += 2) {
                    ArrayList<String> tmp;
                    FSDic lexBin = (FSDic)this.lexBins.get(idic);
                    if ((Integer)this.lexBins.get(idic + 1) > iprio || (tmp = lexBin.lookUpSimple(simpletoken, 0, this)) == null || tmp.size() <= 0) continue;
                    if (sols == null) {
                        sols = new ArrayList();
                    }
                    sols.addAll(tmp);
                }
                if (sols != null) {
                    this.filterOutComplexInfos(sols);
                }
                if (sols != null && sols.size() > 0) break;
            }
            this.lexforalldics.put(simpletoken, sols);
            return sols;
        }
        if (position < 0) {
            for (int iprio = -9; iprio < 10; ++iprio) {
                ArrayList<String> tmp;
                int idic;
                for (idic = 0; idic < this.lexBins.size(); idic += 2) {
                    FSDic lexBin = (FSDic)this.lexBins.get(idic);
                    if ((Integer)this.lexBins.get(idic + 1) != iprio || (tmp = lexBin.lookUpSimple(simpletoken, 0, this)) == null || tmp.size() <= 0) continue;
                    if (sols == null) {
                        sols = new ArrayList();
                    }
                    sols.addAll(tmp);
                }
                for (idic = 0; idic < this.lexGrms.size(); idic += 2) {
                    Grammar lexGrm = (Grammar)this.lexGrms.get(idic);
                    if ((Integer)this.lexGrms.get(idic + 1) != iprio || (tmp = lexGrm.matchWord(simpletoken, this, processconstraints, currentline, cpos)) == null || tmp.size() <= 0) continue;
                    if (sols == null) {
                        sols = new ArrayList();
                    }
                    sols.addAll(tmp);
                }
                if (sols != null) break;
            }
            if (sols == null || sols.isEmpty()) {
                return null;
            }
            ArrayList<String> res = new ArrayList<String>();
            for (int isol = 0; isol < sols.size(); ++isol) {
                if (sols.get(isol).getClass() == String.class) {
                    res.add(sols.get(isol));
                    res.add(Integer.toString(simpletoken.length()));
                    continue;
                }
                res.add(sols.get(isol + 1));
                res.add(sols.get(isol));
                ++isol;
            }
            return res;
        }
        for (int iprio = -9; iprio < 10; ++iprio) {
            for (int idic = 0; idic < this.lexBins.size(); idic += 2) {
                ArrayList<String> tmp;
                if ((Integer)this.lexBins.get(idic + 1) != iprio) continue;
                FSDic lexBin = (FSDic)this.lexBins.get(idic);
                if (lexBin.bufferc == null || (tmp = lexBin.lookUpCompound(this.CurrentLine, position, this)) == null || tmp.size() <= 0) continue;
                if (sols == null) {
                    sols = new ArrayList();
                }
                sols.addAll(tmp);
            }
            if (sols != null) break;
        }
        if (sols != null && !this.Lan.asianTokenizer) {
            this.filterSimples(sols, simpletoken.length());
        }
        return sols;
    }

    final ArrayList<String> getRidOfConstraintsOrAngles(ArrayList<String> sequence, char Rid) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < sequence.size(); ++i) {
            String tok = sequence.get(i);
            if (tok == null) continue;
            if (Rid == 'C') {
                if (Dic.isALexicalConstraint(tok)) continue;
                res.add(tok);
                continue;
            }
            if (tok.charAt(0) == '<' || tok.charAt(0) == '{') {
                res.add(tok.substring(1, 1 + tok.length() - 2));
                continue;
            }
            res.add(tok);
        }
        return res;
    }

    private void filterSimples(ArrayList<String> sols, int simpleTokenLength) {
        String entry = null;
        String info = null;
        int i = 0;
        while (i < sols.size()) {
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_info = new RefObject<Object>(info);
            Dic.parseDELAS(sols.get(i), tempRef_entry, tempRef_info);
            entry = (String)tempRef_entry.argvalue;
            info = (String)tempRef_info.argvalue;
            if (entry.length() == simpleTokenLength) {
                sols.subList(i, 2 + i).clear();
                continue;
            }
            i += 2;
        }
    }

    private final boolean filterUnamb(ArrayList<String> sols) {
        String myfeature;
        int i;
        String entry = null;
        String info = null;
        boolean found = false;
        for (i = 0; i < sols.size(); i += 2) {
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_info = new RefObject<Object>(info);
            Dic.parseDELAS(sols.get(i), tempRef_entry, tempRef_info);
            entry = (String)tempRef_entry.argvalue;
            info = (String)tempRef_info.argvalue;
            myfeature = Dic.lookFor("UNAMB", info, null);
            if (myfeature == null) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        if (found) {
            i = 0;
            while (i < sols.size()) {
                RefObject<Object> tempRef_entry2 = new RefObject<Object>(entry);
                RefObject<Object> tempRef_info2 = new RefObject<Object>(info);
                Dic.parseDELAS(sols.get(i), tempRef_entry2, tempRef_info2);
                entry = (String)tempRef_entry2.argvalue;
                info = (String)tempRef_info2.argvalue;
                myfeature = Dic.lookFor("UNAMB", info, null);
                if (myfeature == null) {
                    sols.subList(i, 2 + i).clear();
                    continue;
                }
                i += 2;
            }
        }
        for (i = 0; i < sols.size(); i += 2) {
            String line = sols.get(i);
            int index = line.indexOf("+UNAMB");
            if (index == -1) continue;
            String line2 = line.substring(0, index) + line.substring(index + new String("+UNAMB").length());
            sols.set(i, line2);
        }
        return true;
    }

    public static void filterNonWords(ArrayList<String> sols) {
        String entry = null;
        String info = null;
        int i = 0;
        while (i < sols.size()) {
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_info = new RefObject<Object>(info);
            Dic.parseDELAS(sols.get(i), tempRef_entry, tempRef_info);
            entry = (String)tempRef_entry.argvalue;
            info = (String)tempRef_info.argvalue;
            String myfeature = Dic.lookFor("NW", info, null);
            if (myfeature != null) {
                sols.subList(i, 2 + i).clear();
                continue;
            }
            i += 2;
        }
    }

    private ArrayList<ArrayList<String>> processTokenAnalysis(int itu, String tokenSequence, String initialtoken, int priority, RefObject<String> errmessage) {
        ArrayList<ArrayList<String>> result = null;
        errmessage.argvalue = null;
        ArrayList tokens = this.Lan.parseSequenceOfTokens(tokenSequence);
        if ((tokens = this.concatenateAllINFOs(tokens)) == null) {
            errmessage.argvalue = "invalid lexical info: " + tokenSequence;
            Dic.writeLog((String)errmessage.argvalue);
            return null;
        }
        for (int i = 0; i < tokens.size(); ++i) {
            ArrayList<String> csols;
            ArrayList<String> csols0;
            String entry = null;
            String lemma = null;
            String category = null;
            String[] features = null;
            String op = null;
            boolean negation = false;
            if (Dic.isALexicalConstraint(tokens.get(i).toString())) {
                csols0 = null;
                RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                RefObject<Object> tempRef_category = new RefObject<Object>(category);
                RefObject<Object> tempRef_features = new RefObject<Object>(features);
                RefObject<Object> tempRef_op = new RefObject<Object>(op);
                RefObject<Boolean> tempRef_negation = new RefObject<Boolean>(negation);
                Dic.parseLexicalConstraint(tokens.get(i).toString(), tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features, tempRef_op, tempRef_negation);
                entry = (String)tempRef_entry.argvalue;
                lemma = (String)tempRef_lemma.argvalue;
                category = (String)tempRef_category.argvalue;
                features = (String[])tempRef_features.argvalue;
                op = (String)tempRef_op.argvalue;
                negation = (Boolean)tempRef_negation.argvalue;
                if (!op.equals("=:")) {
                    Dic.writeLog("Operator '" + op + "' in symbol " + tokens.get(i).toString() + " is invalid");
                }
                if (category != null && category.length() > 1) {
                    if (!initialtoken.equals(entry)) {
                        if (this.recursiveMorphology == null) {
                            this.recursiveMorphology = new HashMap();
                        } else if (this.recursiveMorphology.containsKey(entry)) {
                            return null;
                        }
                        this.recursiveMorphology.put(entry, null);
                        csols0 = this.lookup(-2, entry, false, null, -2, errmessage);
                        if (csols0 == null && errmessage.argvalue != null) {
                            return null;
                        }
                        this.recursiveMorphology.remove(entry);
                    }
                } else if (lemma != null && lemma.length() > 1 && !initialtoken.equals(entry)) {
                    if (this.recursiveMorphology == null) {
                        this.recursiveMorphology = new HashMap();
                    } else if (this.recursiveMorphology.containsKey(entry)) {
                        return null;
                    }
                    this.recursiveMorphology.put(entry, null);
                    csols0 = this.lookup(-2, entry, false, null, -2, errmessage);
                    if (csols0 == null && errmessage.argvalue != null) {
                        return null;
                    }
                    this.recursiveMorphology.remove(entry);
                }
                if (csols0 == null || csols0.isEmpty()) {
                    return null;
                }
                ArrayList<String> csols2 = new ArrayList<String>(csols0);
                if (category != null) {
                    Grammar.filterConstraint(csols2, entry, lemma, category, features, negation);
                }
                if (csols2.isEmpty()) {
                    return null;
                }
                csols = Grammar.transformConstraintIntoLUNoLU(csols2);
            } else if (tokens.get(i).toString().charAt(0) == '<') {
                csols = new ArrayList();
                RefObject<ArrayList<String>> tempRef_csols = new RefObject<ArrayList<String>>(csols);
                Dic.normalizeLexemeSymbol(tokens.get(i).toString(), this, tempRef_csols);
                csols = (ArrayList<String>)tempRef_csols.argvalue;
            } else {
                csols0 = this.lookup(-1, tokens.get(i).toString(), false, tokens.get(i).toString(), 0, null);
                if (csols0 == null) {
                    csols = new ArrayList<String>();
                    csols.add(tokens.get(i).toString());
                } else {
                    csols = Grammar.addBracketsAround(csols0);
                }
            }
            if (result == null) {
                result = new ArrayList<ArrayList<String>>();
            }
            result.add(csols);
        }
        return result;
    }

    private static void recursiveDevelop(ArrayList<String> prefix, ArrayList<ArrayList<String>> expression, ArrayList<ArrayList<String>> result) {
        if (expression.isEmpty()) {
            result.add(new ArrayList<String>(prefix));
            return;
        }
        ArrayList<String> fact = expression.get(0);
        if (fact == null) {
            ArrayList expSublist = new ArrayList();
            if (expression.size() == 1) {
                expSublist = new ArrayList();
            } else if (expression.size() == 2) {
                expSublist.add(expression.get(1));
            } else {
                expSublist = (ArrayList)expression.subList(1, expression.size() - 1);
            }
            Engine.recursiveDevelop(prefix, expSublist, result);
        } else {
            for (int iterm = 0; iterm < fact.size(); ++iterm) {
                ArrayList expSublist = new ArrayList();
                ArrayList<String> tmp = new ArrayList<String>(prefix);
                tmp.add(fact.get(iterm));
                if (expression.size() == 1) {
                    expSublist = new ArrayList();
                } else if (expression.size() == 2) {
                    expSublist.add(expression.get(1));
                } else {
                    expSublist = (ArrayList)expression.subList(1, expression.size() - 1);
                }
                Engine.recursiveDevelop(tmp, expSublist, result);
            }
        }
    }

    private final boolean isComplex(String info, RefObject<Boolean> thereisalexicalunit) {
        if (thereisalexicalunit != null) {
            thereisalexicalunit.argvalue = false;
            boolean iscomplex = false;
            if (info == null) {
                return false;
            }
            if (info.equals("")) {
                return false;
            }
            if (info.charAt(0) != '<' && info.charAt(0) != '{') {
                return false;
            }
            for (int i = 0; i < info.length(); ++i) {
                String simplelex;
                int j;
                if (info.charAt(i) == '<') {
                    iscomplex = true;
                    j = 0;
                    while (j + i < info.length() && info.charAt(i + j) != '>') {
                        ++j;
                    }
                    simplelex = info.substring(i, i + j + 1);
                } else if (info.charAt(i) == '{') {
                    iscomplex = true;
                    j = 0;
                    while (j + i < info.length() && info.charAt(i + j) != '}') {
                        ++j;
                    }
                    simplelex = info.substring(i, i + j + 1);
                } else {
                    return false;
                }
                if (Dic.isALexicalSymbol(simplelex)) {
                    thereisalexicalunit.argvalue = true;
                    return true;
                }
                i += j;
            }
            return iscomplex;
        }
        return info != null && !info.equals("") && (info.charAt(0) == '<' || info.charAt(0) == '{');
    }

    private String getLexicalUnit(ArrayList<String> sequence, int varnumber) {
        int nb = 1;
        for (int iseq = 0; iseq < sequence.size(); ++iseq) {
            String token = sequence.get(iseq);
            if (token == null || token.length() <= 4) continue;
            int istrt = 0;
            int found = token.indexOf("<LU=", istrt);
            while (found != -1) {
                int level = 1;
                int len = 4;
                while (found + len < token.length()) {
                    if (token.charAt(found + len) == '<') {
                        ++level;
                    } else if (token.charAt(found + len) == '>' && --level == 0) {
                        ++len;
                        break;
                    }
                    ++len;
                }
                if (nb == varnumber) {
                    return token.substring(found, found + len);
                }
                ++nb;
                found = token.indexOf("<LU=", found + len);
            }
        }
        return null;
    }

    private void deleteAllLUsFromOutput(ArrayList<String> sequence) {
        int iseq = 0;
        while (iseq < sequence.size()) {
            String token = sequence.get(iseq);
            if (token == null || token.length() < 4) {
                ++iseq;
                continue;
            }
            int istrt = 0;
            int found = token.indexOf("<LU=", istrt);
            if (found == -1) {
                ++iseq;
                continue;
            }
            int len = 4;
            while (found + len < token.length() && token.charAt(found + len) != '>') {
                ++len;
            }
            sequence.set(iseq, token.substring(0, found) + token.substring(found + len + 1));
        }
    }

    private final boolean isASyntacticFeature(String feature) {
        if (this.prop_inf == null) {
            return feature.length() > 1;
        }
        int index = feature.indexOf(61);
        if (index != -1) {
            String feat = feature.substring(index + 1);
            return !this.prop_inf.containsKey(feat);
        }
        return !this.prop_inf.containsKey(feature);
    }

    private final boolean isAninflectionalFeature(String feature) {
        if (feature.equals("NW")) {
            return false;
        }
        if (feature.equals("FXC")) {
            return false;
        }
        if (this.prop_inf == null) {
            return feature.length() == 1;
        }
        int index = feature.indexOf(61);
        if (index != -1) {
            String feat = feature.substring(index + 1);
            return this.prop_inf.containsKey(feat);
        }
        return this.prop_inf.containsKey(feature);
    }

    private String getVariableValue(ArrayList<String> sequence, int varnumber, char vartype) {
        String lu = this.getLexicalUnit(sequence, varnumber);
        if (lu == null) {
            return null;
        }
        String entry = null;
        String category = null;
        String lemma = null;
        String[] features = null;
        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
        RefObject<Object> tempRef_category = new RefObject<Object>(category);
        RefObject<Object> tempRef_features = new RefObject<Object>(features);
        Dic.parseLexicalUnit(lu, tempRef_entry, tempRef_lemma, tempRef_category, tempRef_features);
        entry = (String)tempRef_entry.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        StringBuilder res = null;
        switch (vartype) {
            case 'E': {
                return entry;
            }
            case 'L': {
                return lemma;
            }
            case 'C': {
                return category;
            }
            case 'S': {
                if (features == null) {
                    return "";
                }
                res = new StringBuilder();
                for (int i = 0; i < features.length; ++i) {
                    if (features[i] == null || features[i].equals("") || !this.isASyntacticFeature(features[i]) || features[i].equals("NW")) continue;
                    res.append("+" + features[i]);
                }
                return res.toString();
            }
            case 'F': {
                if (features == null) {
                    return "";
                }
                res = new StringBuilder();
                for (int i = 0; i < features.length; ++i) {
                    if (features[i] == null || features[i].equals("") || !this.isAninflectionalFeature(features[i])) continue;
                    res.append("+" + features[i]);
                }
                return res.toString();
            }
        }
        return null;
    }

    private String getMorphoValue(String varname, ArrayList<String> inputs) {
        int index = -1;
        for (int iinput = inputs.size() - 1; iinput >= 0; --iinput) {
            String si = inputs.get(iinput);
            if (si == null || si.length() == 0 || !si.equals("$(" + varname)) continue;
            index = iinput;
            break;
        }
        StringBuilder res = new StringBuilder();
        int rec = 0;
        ++index;
        while (index < inputs.size()) {
            String si = inputs.get(index);
            if (si != null && si.length() != 0) {
                if (si.length() > 2 && si.charAt(0) == '$' && si.charAt(1) == '(') {
                    ++rec;
                } else if (si.length() >= 2 && si.charAt(0) == '$' && si.charAt(1) == ')') {
                    if (rec == 0) break;
                    --rec;
                } else {
                    res.append(si);
                }
            }
            ++index;
        }
        return res.toString();
    }

    private void removeConstraints(ArrayList<String> sequence) {
        int iseq = 0;
        while (iseq < sequence.size()) {
            String token = sequence.get(iseq);
            if (Dic.isALexicalConstraint(token)) {
                sequence.remove(iseq);
                continue;
            }
            ++iseq;
        }
    }

    private ArrayList concatenateAllINFOs(ArrayList sequence) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> suffixes = new ArrayList<String>();
        for (int iseq = 0; iseq < sequence.size(); ++iseq) {
            String token0 = sequence.get(iseq).toString();
            String token = token0.replace('{', '<').replace('}', '>');
            if (token.length() >= 5 && token.substring(0, 5).equals("<INFO")) {
                suffixes.add(token);
                continue;
            }
            result.add(token);
        }
        if (suffixes.size() > 0) {
            if (result.isEmpty()) {
                result.add("<INVALIDANNOTATION>");
                String[] res0 = new String[result.size()];
                result.toArray(res0);
                return result;
            }
            String last0 = (String)result.get(result.size() - 1);
            String last = last0.substring(0, last0.length() - 1);
            for (int i = 0; i < suffixes.size(); ++i) {
                String suf0 = (String)suffixes.get(i);
                String suf = suf0.substring(5, 5 + suf0.length() - 6);
                last = last + suf;
            }
            result.set(result.size() - 1, last + ">");
        }
        return result;
    }

    public final boolean tokenize(Ntext text, ArrayList<Object> annotations, HashMap<String, ArrayList<String>> simpleWordMorphology, RefObject<String> errmessage) {
        errmessage.argvalue = null;
        Object hCorpusLexemes = null;
        HashMap<String, Integer> hCorpusUnknowns = null;
        text.hLexemes = new HashMap();
        text.hUnknowns = new HashMap();
        text.hTokens = new HashMap();
        text.nbOfWords = 0;
        text.nbOfTokens = 0;
        text.nbOfDelimiters = 0;
        text.nbOfDigits = 0;
        text.nbOfTokens = 0;
        text.nbOfWords = 0;
        int progressPercentage = 0;
        HashMap<String, ArrayList> processConstraints = new HashMap<String, ArrayList>();
        for (int itu = 1; itu < text.mft.tuAddresses.length; ++itu) {
            if (this.BackgroundWorking) {
                if (this.backgroundWorker.isCancellationPending()) {
                    return false;
                }
                int nprogress = (int)((float)itu * 100.0f / (float)text.nbOfTextUnits);
                if (nprogress != progressPercentage) {
                    progressPercentage = nprogress;
                    if (this.backgroundWorker.isBusy()) {
                        this.backgroundWorker.reportProgress(nprogress * 20 / 100);
                    }
                }
            }
            this.CurrentLine = text.buffer.substring(text.mft.tuAddresses[itu], text.mft.tuAddresses[itu] + text.mft.tuLengths[itu]);
            int ichar = 0;
            while (ichar < this.CurrentLine.length()) {
                ArrayList<String> sols;
                String token;
                if (Character.isWhitespace(this.CurrentLine.charAt(ichar))) {
                    ++ichar;
                    continue;
                }
                int cpos = ichar++;
                ++text.nbOfTokens;
                if (Language.isLetter(this.CurrentLine.charAt(cpos))) {
                    ++text.nbOfWords;
                    if (this.Lan.asianTokenizer) {
                        token = this.CurrentLine.substring(cpos, cpos + 1);
                    } else {
                        ++ichar;
                        while (ichar < this.CurrentLine.length() && Language.isLetter(this.CurrentLine.charAt(ichar))) {
                            ++ichar;
                        }
                        token = this.CurrentLine.substring(cpos, ichar);
                    }
                } else {
                    if (Character.isDigit(this.CurrentLine.charAt(cpos))) {
                        ++text.nbOfDigits;
                    } else {
                        ++text.nbOfDelimiters;
                    }
                    ++ichar;
                    token = this.CurrentLine.substring(cpos, cpos + 1);
                }
                boolean found = false;
                ArrayList<String> s_sols = null;
                if (!this.Lan.asianTokenizer && Language.isLetter(token.charAt(0))) {
                    if (this.Lan.isoName.equals("ar") || this.Lan.isoName.equals("he") || this.Lan.isoName.equals("vi")) {
                        s_sols = this.lookup(-1, token, true, this.CurrentLine, cpos, null);
                        if (s_sols != null) {
                            Engine.filterNonWords(s_sols);
                            this.filterUnamb(s_sols);
                        }
                    } else if (simpleWordMorphology.containsKey(token)) {
                        s_sols = simpleWordMorphology.get(token);
                    } else {
                        s_sols = this.lookup(-1, token, true, this.CurrentLine, cpos, null);
                        if (s_sols == null) {
                            simpleWordMorphology.put(token, null);
                        } else {
                            Engine.filterNonWords(s_sols);
                            this.filterUnamb(s_sols);
                            simpleWordMorphology.put(token, s_sols);
                        }
                    }
                }
                boolean thereisunamb = false;
                ArrayList<String> c_sols = this.lookup(cpos, token, false, null, -1, null);
                if (c_sols != null && c_sols.size() > 0) {
                    Engine.filterNonWords(c_sols);
                    thereisunamb = this.filterUnamb(c_sols);
                    if (s_sols != null && s_sols.size() > 0) {
                        if (!thereisunamb) {
                            sols = new ArrayList<String>(s_sols);
                            sols.addAll(c_sols);
                        } else {
                            sols = new ArrayList<String>(c_sols);
                        }
                    } else {
                        sols = new ArrayList<String>(c_sols);
                    }
                } else {
                    sols = s_sols != null && s_sols.size() > 0 ? new ArrayList<String>(s_sols) : null;
                }
                if (sols != null) {
                    for (int i = 0; i < sols.size(); i += 2) {
                        String entry = null;
                        String lemma = null;
                        String info = null;
                        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                        RefObject<Object> tempRef_info = new RefObject<Object>(info);
                        boolean tempVar = !Dic.parseDELAF(sols.get(i).toString(), tempRef_entry, tempRef_lemma, tempRef_info, null, null, null);
                        entry = (String)tempRef_entry.argvalue;
                        lemma = (String)tempRef_lemma.argvalue;
                        info = (String)tempRef_info.argvalue;
                        if (tempVar) continue;
                        int len = Integer.parseInt(sols.get(i + 1).toString());
                        if (thereisunamb) {
                            ichar = cpos + len;
                        }
                        boolean lextags = false;
                        RefObject<Boolean> tempRef_lextags = new RefObject<Boolean>(lextags);
                        boolean tempVar2 = this.isComplex(info, tempRef_lextags);
                        lextags = (Boolean)tempRef_lextags.argvalue;
                        if (tempVar2) {
                            ArrayList defactorizedexp = new ArrayList();
                            if (processConstraints.containsKey(info)) {
                                defactorizedexp = (ArrayList)processConstraints.get(info);
                            } else {
                                ArrayList<ArrayList<String>> resultingexp = this.processTokenAnalysis(itu, info, token, 1, errmessage);
                                if (resultingexp == null) {
                                    if (errmessage.argvalue == null || ((String)errmessage.argvalue).equals("")) continue;
                                    return false;
                                }
                                Engine.recursiveDevelop(new ArrayList<String>(), resultingexp, defactorizedexp);
                                if (lextags) {
                                    for (int iterm = 0; iterm < defactorizedexp.size(); ++iterm) {
                                        ArrayList sequence = (ArrayList)defactorizedexp.get(iterm);
                                        this.removeConstraints(sequence);
                                        sequence = this.concatenateAllINFOs(sequence);
                                        defactorizedexp.set(iterm, sequence);
                                    }
                                }
                                processConstraints.put(info, defactorizedexp);
                            }
                            for (int iterm = 0; iterm < defactorizedexp.size(); ++iterm) {
                                ArrayList sequence = (ArrayList)defactorizedexp.get(iterm);
                                for (int k = 0; k < sequence.size(); ++k) {
                                    String seq = (String)sequence.get(k);
                                    seq = seq.substring(1, seq.length() - 1);
                                    this.addLexemeToText(annotations, text.hLexemes, seq, text.mft, itu, cpos, cpos + len);
                                }
                            }
                            found = true;
                            continue;
                        }
                        this.addLexemeToText(annotations, text.hLexemes, sols.get(i).toString(), text.mft, itu, cpos, cpos + len);
                        found = true;
                    }
                }
                if (found || !Language.isLetter(this.CurrentLine.charAt(cpos))) continue;
                this.addUnknown(annotations, hCorpusUnknowns, text.hUnknowns, token);
            }
        }
        return true;
    }

    public final boolean computeAmbiguities(String fname, Ntext text, ArrayList<Object> annotations, RefObject<HashMap<String, ArrayList<Object>>> hAmbiguities) {
        int progressPercentage = 0;
        for (int itu = 1; itu < text.mft.tuAddresses.length; ++itu) {
            if (this.BackgroundWorking) {
                if (this.backgroundWorker.isCancellationPending()) {
                    return false;
                }
                int nprogress = (int)((float)itu * 100.0f / (float)text.nbOfTextUnits);
                if (nprogress != progressPercentage) {
                    progressPercentage = nprogress;
                    if (this.backgroundWorker.isBusy()) {
                        this.backgroundWorker.reportProgress(nprogress);
                    }
                }
            }
            ArrayList<AmbiguitiesUnambiguitiesObject> ambs = text.mft.getAllAmbiguitiesInTextUnit(itu);
            for (int i = 0; i < ambs.size(); ++i) {
                ArrayList addresses;
                double beg = ambs.get(i).getRelBegAddress() + (double)text.mft.tuAddresses[itu];
                ArrayList<Integer> tokenids = ambs.get(i).getTokenIds();
                double end = ambs.get(i).getRelEndAddress() + (double)text.mft.tuAddresses[itu];
                StringBuilder ambannotations = new StringBuilder();
                for (int tk : tokenids) {
                    String info;
                    RefObject<Object> tempRef_info;
                    String lemma;
                    RefObject<Object> tempRef_lemma;
                    String entry;
                    RefObject<Object> tempRef_entry;
                    String lex = (String)annotations.get(tk);
                    boolean tempVar = !Dic.parseDELAF(lex, tempRef_entry = new RefObject<Object>((entry = null)), tempRef_lemma = new RefObject<Object>((lemma = null)), tempRef_info = new RefObject<Object>((info = null)), null, null, null);
                    entry = (String)tempRef_entry.argvalue;
                    lemma = (String)tempRef_lemma.argvalue;
                    info = (String)tempRef_info.argvalue;
                    if (tempVar) continue;
                    if (lemma != null) {
                        ambannotations.append("<" + Dic.protectComma(lemma) + "," + info + "> ");
                        continue;
                    }
                    ambannotations.append("<" + info + "> ");
                }
                String amb = ambannotations.toString();
                if (((HashMap)hAmbiguities.argvalue).containsKey(amb)) {
                    addresses = (ArrayList)((HashMap)hAmbiguities.argvalue).get(amb);
                    addresses.add(beg);
                    addresses.add(end);
                    addresses.add(itu);
                    continue;
                }
                addresses = new ArrayList();
                addresses.add(beg);
                addresses.add(end);
                addresses.add(itu);
                ((HashMap)hAmbiguities.argvalue).put(amb, addresses);
            }
        }
        return true;
    }

    public final boolean computeUnambiguities(String fname, Ntext text, ArrayList<Object> annotations, RefObject<HashMap<String, ArrayList<Object>>> hUnambiguities) {
        int progressPercentage = 0;
        for (int itu = 1; itu < text.mft.tuAddresses.length; ++itu) {
            if (this.BackgroundWorking) {
                if (this.backgroundWorker.isCancellationPending()) {
                    return false;
                }
                int nprogress = (int)((float)itu * 100.0f / (float)text.nbOfTextUnits);
                if (nprogress != progressPercentage) {
                    progressPercentage = nprogress;
                    if (this.backgroundWorker.isBusy()) {
                        this.backgroundWorker.reportProgress(nprogress);
                    }
                }
            }
            ArrayList<AmbiguitiesUnambiguitiesObject> ambs = text.mft.getAllUnambiguitiesInTextUnit(itu);
            for (int i = 0; i < ambs.size(); ++i) {
                ArrayList addresses;
                double beg = ambs.get(i).getRelBegAddress() + (double)text.mft.tuAddresses[itu];
                ArrayList<Integer> tokenids = ambs.get(i).getTokenIds();
                double end = ambs.get(i).getRelEndAddress() + (double)text.mft.tuAddresses[itu];
                StringBuilder ambannotations = new StringBuilder();
                for (int tk : tokenids) {
                    String info;
                    RefObject<Object> tempRef_info;
                    String lemma;
                    RefObject<Object> tempRef_lemma;
                    String entry;
                    RefObject<Object> tempRef_entry;
                    String lex = (String)annotations.get(tk);
                    boolean tempVar = !Dic.parseDELAF(lex, tempRef_entry = new RefObject<Object>((entry = null)), tempRef_lemma = new RefObject<Object>((lemma = null)), tempRef_info = new RefObject<Object>((info = null)), null, null, null);
                    entry = (String)tempRef_entry.argvalue;
                    lemma = (String)tempRef_lemma.argvalue;
                    info = (String)tempRef_info.argvalue;
                    if (tempVar) continue;
                    if (lemma != null) {
                        ambannotations.append("<" + Dic.protectComma(lemma) + "," + info + ">");
                        continue;
                    }
                    ambannotations.append("<" + info + ">");
                }
                String amb = ambannotations.toString();
                if (((HashMap)hUnambiguities.argvalue).containsKey(amb)) {
                    addresses = (ArrayList)((HashMap)hUnambiguities.argvalue).get(amb);
                    addresses.add(beg);
                    addresses.add(end);
                    addresses.add(itu);
                    continue;
                }
                addresses = new ArrayList();
                addresses.add(beg);
                addresses.add(end);
                addresses.add(itu);
                ((HashMap)hUnambiguities.argvalue).put(amb, addresses);
            }
        }
        return true;
    }

    public final String enrichDictionary(String[] dictionarylines) {
        StringBuilder resultingdic = new StringBuilder();
        int progressPercentage = 0;
        for (int itu = 0; itu < dictionarylines.length; ++itu) {
            ArrayList sols;
            ArrayList<String> c_sols;
            String currentline;
            if (this.BackgroundWorking) {
                if (this.backgroundWorker.isCancellationPending()) {
                    return null;
                }
                int nprogress = (int)((float)itu * 100.0f / (float)dictionarylines.length);
                if (nprogress != progressPercentage) {
                    progressPercentage = nprogress;
                    if (this.backgroundWorker.isBusy()) {
                        this.backgroundWorker.reportProgress(nprogress);
                    }
                }
            }
            if ((currentline = dictionarylines[itu]).equals("") || currentline.charAt(0) == '#') {
                resultingdic.append(currentline + "\n");
                continue;
            }
            String lineentry = null;
            RefObject<Object> tempRef_lineentry = new RefObject<Object>(lineentry);
            String linelemma = null;
            RefObject<Object> tempRef_linelemma = new RefObject<Object>(linelemma);
            String linecategory = null;
            RefObject<Object> tempRef_linecategory = new RefObject<Object>(linecategory);
            String[] linefeatures = null;
            RefObject<Object> tempRef_linefeatures = new RefObject<Object>(linefeatures);
            boolean tempVar = !Dic.parseDELAF(currentline, tempRef_lineentry, tempRef_linelemma, null, tempRef_linecategory, null, tempRef_linefeatures);
            lineentry = (String)tempRef_lineentry.argvalue;
            linelemma = (String)tempRef_linelemma.argvalue;
            linecategory = (String)tempRef_linecategory.argvalue;
            linefeatures = (String[])tempRef_linefeatures.argvalue;
            if (tempVar || linecategory.equals("")) continue;
            ArrayList<String> s_sols = null;
            if (!this.Lan.asianTokenizer) {
                s_sols = this.lookup(-1, lineentry, true, null, 0, null);
            }
            if ((c_sols = this.lookup(0, lineentry, false, null, -1, null)) != null && c_sols.size() > 0) {
                if (s_sols != null && s_sols.size() > 0) {
                    sols = (ArrayList)s_sols.clone();
                    sols.addAll(c_sols);
                } else {
                    sols = (ArrayList)c_sols.clone();
                }
            } else {
                sols = s_sols != null && s_sols.size() > 0 ? (ArrayList)s_sols.clone() : null;
            }
            if (sols == null) {
                resultingdic.append(currentline + "\n");
                continue;
            }
            StringBuilder linefeats = new StringBuilder();
            if (linefeatures != null) {
                for (String linefeat : linefeatures) {
                    linefeats.append("+" + linefeat);
                }
            }
            boolean didsomething = false;
            for (int i = 0; i < sols.size(); i += 2) {
                StringBuilder newfeats = new StringBuilder(linefeats.toString());
                String entry = null;
                String lemma = null;
                String category = null;
                String[] features = null;
                RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                RefObject<Object> tempRef_category = new RefObject<Object>(category);
                RefObject<Object> tempRef_features = new RefObject<Object>(features);
                boolean tempVar2 = !Dic.parseDELAF((String)sols.get(i), tempRef_entry, tempRef_lemma, null, tempRef_category, null, tempRef_features);
                entry = (String)tempRef_entry.argvalue;
                lemma = (String)tempRef_lemma.argvalue;
                category = (String)tempRef_category.argvalue;
                features = (String[])tempRef_features.argvalue;
                if (tempVar2 || entry.length() < lineentry.length() || !entry.equals(lemma) || !linecategory.equals(category)) continue;
                Dic.getRidOfSpecialFeaturesPlus(features);
                if (features != null && features.length > 0) {
                    ArrayList<String> newfeatures = new ArrayList<String>();
                    for (String feat : features) {
                        boolean found = false;
                        if (linefeatures != null && linefeatures.length > 0) {
                            for (String linefeat : linefeatures) {
                                if (!feat.equals(linefeat)) continue;
                                found = true;
                                break;
                            }
                        }
                        if (found) continue;
                        newfeatures.add(feat);
                    }
                    for (String newfeat : newfeatures) {
                        newfeats.append("+" + newfeat);
                    }
                }
                String resline = entry + "," + category + newfeats;
                resultingdic.append(resline + "\n");
                didsomething = true;
            }
            if (didsomething) continue;
            resultingdic.append(currentline + "\n");
        }
        return resultingdic.toString();
    }

    public final void computeTokens(Ntext text) {
        HashMap<String, Integer> hCorpusTokens = null;
        text.hTokens = new HashMap();
        text.nbOfWords = 0;
        text.nbOfTokens = 0;
        int progressPercentage = 0;
        for (int itu = 1; itu < text.mft.tuAddresses.length; ++itu) {
            this.CurrentLine = text.buffer.substring(text.mft.tuAddresses[itu], text.mft.tuAddresses[itu] + text.mft.tuLengths[itu]);
            int ichar = 0;
            while (ichar < this.CurrentLine.length()) {
                int epos;
                String token;
                if (this.BackgroundWorking) {
                    if (this.backgroundWorker.isCancellationPending()) {
                        return;
                    }
                    int nprogress = (int)((float)ichar * 100.0f / (float)this.CurrentLine.length());
                    if (nprogress != progressPercentage) {
                        progressPercentage = nprogress;
                        if (this.backgroundWorker.isBusy()) {
                            this.backgroundWorker.reportProgress(nprogress);
                        }
                    }
                }
                if (Character.isWhitespace(this.CurrentLine.charAt(ichar))) {
                    ++ichar;
                    continue;
                }
                int cpos = ichar;
                ++text.nbOfTokens;
                if (Language.isLetter(this.CurrentLine.charAt(cpos)) || this.CurrentLine.charAt(cpos) == '\'' && this.Lan.russianTokenizer) {
                    if (this.Lan.asianTokenizer) {
                        ++text.nbOfWords;
                        token = this.CurrentLine.substring(cpos, cpos + 1);
                        epos = ++ichar;
                    } else if (this.Lan.russianTokenizer) {
                        ++text.nbOfWords;
                        ++ichar;
                        while (ichar < this.CurrentLine.length() && (this.CurrentLine.charAt(ichar) == '\'' || Language.isLetter(this.CurrentLine.charAt(ichar)))) {
                            ++ichar;
                        }
                        token = this.CurrentLine.substring(cpos, ichar);
                        epos = ichar;
                    } else {
                        ++text.nbOfWords;
                        ++ichar;
                        while (ichar < this.CurrentLine.length() && Language.isLetter(this.CurrentLine.charAt(ichar))) {
                            ++ichar;
                        }
                        token = this.CurrentLine.substring(cpos, ichar);
                        epos = ichar;
                    }
                    this.addToken(hCorpusTokens, text.hTokens, token, text.mft.tuAddresses[itu] + cpos, text.mft.tuAddresses[itu] + epos);
                    continue;
                }
                token = this.CurrentLine.substring(cpos, cpos + 1);
                epos = ++ichar;
            }
        }
    }

    public final void computeDigrams(Ntext text) {
        HashMap<String, Integer> hCorpusDigrams = null;
        text.hDigrams = new HashMap();
        int progressPercentage = 0;
        for (int itu = 1; itu < text.mft.tuAddresses.length; ++itu) {
            String lasttoken = null;
            int lastbeg = 0;
            this.CurrentLine = text.buffer.substring(text.mft.tuAddresses[itu], text.mft.tuAddresses[itu] + text.mft.tuLengths[itu]);
            int ichar = 0;
            while (ichar < this.CurrentLine.length()) {
                String token;
                int cpos;
                if (this.BackgroundWorking) {
                    if (this.backgroundWorker.isCancellationPending()) {
                        return;
                    }
                    int nprogress = (int)((float)ichar * 100.0f / (float)this.CurrentLine.length());
                    if (nprogress != progressPercentage) {
                        progressPercentage = nprogress;
                        if (this.backgroundWorker.isBusy()) {
                            this.backgroundWorker.reportProgress(nprogress);
                        }
                    }
                }
                if (Character.isWhitespace(this.CurrentLine.charAt(ichar))) {
                    ++ichar;
                    continue;
                }
                if (Language.isLetter(this.CurrentLine.charAt(cpos = ichar++))) {
                    int epos;
                    if (this.Lan.asianTokenizer) {
                        token = this.CurrentLine.substring(cpos, cpos + 1);
                        epos = ichar;
                    } else {
                        ++ichar;
                        while (ichar < this.CurrentLine.length() && Language.isLetter(this.CurrentLine.charAt(ichar))) {
                            ++ichar;
                        }
                        token = this.CurrentLine.substring(cpos, ichar);
                        epos = ichar;
                    }
                    if (lasttoken != null) {
                        String digram = this.Lan.asianTokenizer ? lasttoken + token : lasttoken + " " + token;
                        this.addToken(hCorpusDigrams, text.hDigrams, digram, text.mft.tuAddresses[itu] + lastbeg, text.mft.tuAddresses[itu] + epos);
                    }
                    lasttoken = token;
                    lastbeg = cpos;
                    continue;
                }
                ++ichar;
                token = this.CurrentLine.substring(cpos, cpos + 1);
            }
        }
    }

    private int filterUnamb(ArrayList<Double> sollengths, ArrayList<ArrayList<Double>> solinputs, ArrayList<ArrayList<String>> solvariables, ArrayList<ArrayList<String>> soloutputs, RefObject<Boolean> found, RefObject<Double> smallerlength) {
        String po;
        int io;
        ArrayList<String> output;
        int found2;
        found.argvalue = false;
        smallerlength.argvalue = -1.0;
        for (int isol = 0; isol < soloutputs.size(); ++isol) {
            ArrayList<String> output2 = soloutputs.get(isol);
            for (int io2 = 0; io2 < output2.size(); ++io2) {
                String po2 = output2.get(io2);
                if (po2 == null || po2.equals("") || po2.indexOf("UNAMB") == -1) continue;
                found.argvalue = true;
                break;
            }
            if (((Boolean)found.argvalue).booleanValue()) break;
        }
        if (!((Boolean)found.argvalue).booleanValue()) {
            return soloutputs.size();
        }
        int maxfound2 = -1;
        int isol = 0;
        while (isol < soloutputs.size()) {
            found2 = 0;
            output = soloutputs.get(isol);
            for (io = 0; io < output.size(); ++io) {
                po = output.get(io);
                if (po == null || po.equals("") || po.indexOf("UNAMB") == -1) continue;
                ++found2;
            }
            if (found2 > maxfound2) {
                maxfound2 = found2;
            }
            if (found2 == 0) {
                sollengths.remove(isol);
                solinputs.remove(isol);
                solvariables.remove(isol);
                soloutputs.remove(isol);
                continue;
            }
            ++isol;
        }
        if (soloutputs.size() > 1) {
            isol = 0;
            while (isol < soloutputs.size()) {
                found2 = 0;
                output = soloutputs.get(isol);
                for (io = 0; io < output.size(); ++io) {
                    po = output.get(io);
                    if (po == null || po.equals("") || po.indexOf("UNAMB") == -1) continue;
                    ++found2;
                }
                if (found2 < maxfound2) {
                    sollengths.remove(isol);
                    solinputs.remove(isol);
                    solvariables.remove(isol);
                    soloutputs.remove(isol);
                    continue;
                }
                ++isol;
            }
        }
        smallerlength.argvalue = (double)sollengths.get(0);
        for (isol = 0; isol < soloutputs.size(); ++isol) {
            if (sollengths.get(isol) < (Double)smallerlength.argvalue) {
                smallerlength.argvalue = (double)sollengths.get(isol);
            }
            ArrayList<String> output3 = soloutputs.get(isol);
            for (int io3 = 0; io3 < output3.size(); ++io3) {
                int iu;
                String po3 = output3.get(io3);
                if (po3 == null || po3.equals("")) continue;
                if (po3.equals("UNAMB") || po3.equals("+UNAMB")) {
                    output3.set(io3, "");
                }
                if ((iu = po3.indexOf("+UNAMB")) == -1) continue;
                output3.set(io3, po3.substring(0, iu));
                output3.set(io3, output3.get(io3) + po3.substring(iu + 6));
            }
        }
        return soloutputs.size();
    }

    private int filterExclude(ArrayList<Double> sollengths, ArrayList<ArrayList<Double>> solinputs, ArrayList<ArrayList<String>> solvariables, ArrayList<ArrayList<String>> soloutputs, RefObject<Boolean> minimlength, RefObject<Double> longestlength) {
        minimlength.argvalue = false;
        longestlength.argvalue = -1.0;
        for (int isol = 0; isol < soloutputs.size(); ++isol) {
            ArrayList<String> output = soloutputs.get(isol);
            for (int io = 0; io < output.size(); ++io) {
                String po = output.get(io);
                if (po == null || po.equals("") || po.indexOf("EXCLUDE") == -1 || !(sollengths.get(isol) > (Double)longestlength.argvalue)) continue;
                minimlength.argvalue = true;
                longestlength.argvalue = (double)sollengths.get(isol);
            }
        }
        if (((Boolean)minimlength.argvalue).booleanValue()) {
            sollengths.clear();
            solinputs.clear();
            solvariables.clear();
            soloutputs.clear();
            return 0;
        }
        return soloutputs.size();
    }

    private int keepLongest(ArrayList<Double> sollengths, ArrayList<ArrayList<Double>> solinputs, ArrayList<ArrayList<String>> solvariables, ArrayList<ArrayList<String>> soloutputs) {
        int isol;
        double longestlength = sollengths.get(0);
        for (isol = 1; isol < sollengths.size(); ++isol) {
            if (!(sollengths.get(isol) > longestlength)) continue;
            longestlength = sollengths.get(isol);
        }
        isol = 0;
        while (isol < sollengths.size()) {
            if (sollengths.get(isol) < longestlength) {
                sollengths.remove(isol);
                solinputs.remove(isol);
                solvariables.remove(isol);
                soloutputs.remove(isol);
                continue;
            }
            ++isol;
        }
        return sollengths.size();
    }

    private int keepShortest(ArrayList<Double> sollengths, ArrayList<ArrayList<Double>> solinputs, ArrayList<ArrayList<String>> solvariables, ArrayList<ArrayList<String>> soloutputs) {
        int isol;
        double shortestlength = sollengths.get(0);
        for (isol = 1; isol < sollengths.size(); ++isol) {
            if (!(sollengths.get(isol) < shortestlength)) continue;
            shortestlength = sollengths.get(isol);
        }
        isol = 0;
        while (isol < soloutputs.size()) {
            if (sollengths.get(isol) > shortestlength) {
                sollengths.remove(isol);
                solinputs.remove(isol);
                solvariables.remove(isol);
                soloutputs.remove(isol);
                continue;
            }
            ++isol;
        }
        return sollengths.size();
    }

    private void deleteONCE(ArrayList<String> output) {
        for (int io = 0; io < output.size(); ++io) {
            String po = output.get(io);
            if (po == null || po.indexOf("<ONCE") != 0) continue;
            output.set(io, null);
        }
    }

    private boolean lexInfoMatchOperator(String lexcategory, String[] lexfeatures, String morphoperator) {
        String[] operators;
        int index = morphoperator.indexOf(43);
        if (index != -1 && index != 0) {
            String cat = morphoperator.substring(0, index);
            if (!lexcategory.equals(cat)) {
                return false;
            }
            operators = Dic.getAllFeaturesWithoutPlus(morphoperator.substring(index));
        } else {
            operators = Dic.getAllFeaturesWithoutPlus(morphoperator);
        }
        for (String op : operators) {
            if (lexcategory.equals(op)) continue;
            boolean found = false;
            for (String lexfeat : lexfeatures) {
                if (op.equals(lexfeat)) {
                    found = true;
                    break;
                }
                if (lexfeat.indexOf(61) == -1) continue;
                String propname = null;
                String propvalue = null;
                RefObject<Object> tempRef_propname = new RefObject<Object>(propname);
                RefObject<Object> tempRef_propvalue = new RefObject<Object>(propvalue);
                Dic.getPropertyNameValue(lexfeat, tempRef_propname, tempRef_propvalue);
                propname = (String)tempRef_propname.argvalue;
                propvalue = (String)tempRef_propvalue.argvalue;
                if (!op.equals(propname) && !op.equals(propvalue)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private ArrayList<String> recDevelop(ArrayList<String[]> listofresults, int index) {
        ArrayList<String> res = new ArrayList<String>();
        if (index >= listofresults.size()) {
            res.add(null);
            return res;
        }
        ArrayList<String> tail = this.recDevelop(listofresults, index + 1);
        for (String c : listofresults.get(index)) {
            for (String t : tail) {
                if (t != null) {
                    res.add(c + " " + t);
                    continue;
                }
                res.add(c);
            }
        }
        return res;
    }

    private String[] GetValues(String text, String varcompletename, RefObject<Boolean> compoundvariable, ArrayList<Double> positions, int rightmargin, ArrayList<String> variables, double cpos, int ipos, RefObject<Language> lan1, Mft textmft, ArrayList<Object> annotations, int tunb, RefObject<ArrayList<HashMap<String, String>>> varvalues, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        int endaddress;
        int indexend;
        int begaddress;
        lan1.argvalue = null;
        compoundvariable.argvalue = false;
        varvalues.argvalue = null;
        errmessage.argvalue = null;
        int index1 = varcompletename.indexOf(95);
        int index2 = varcompletename.indexOf(36, 1);
        int index = index1;
        if (index == -1) {
            index = index2;
        } else if (index2 == -1) {
            index = index1;
        } else if (index2 < index) {
            index = index2;
        }
        String varname = index == -1 ? ((index = varcompletename.indexOf(36)) == -1 ? varcompletename : varcompletename.substring(0, index)) : varcompletename.substring(0, index);
        if (!varcompletename.equals(varname)) {
            compoundvariable.argvalue = true;
        }
        if (varname.equals("THIS")) {
            String var;
            index = ipos;
            begaddress = (int)positions.get(index).doubleValue();
            for (indexend = index + 1; indexend < positions.size() && (var = variables.get(indexend)) == null; ++indexend) {
            }
            if (indexend >= positions.size()) {
                indexend = index;
                endaddress = (int)positions.get(indexend).doubleValue();
            } else {
                endaddress = ++indexend >= positions.size() ? (int)positions.get(indexend - 1).doubleValue() : (int)positions.get(indexend).doubleValue();
            }
        } else {
            String si;
            int iinput;
            index = -1;
            for (iinput = ipos; iinput >= 0; --iinput) {
                si = variables.get(iinput);
                if (si == null || si.length() == 0 || !si.equals("$(" + varname)) continue;
                index = iinput;
                break;
            }
            if (index == -1) {
                for (iinput = ipos; iinput < variables.size(); ++iinput) {
                    si = variables.get(iinput);
                    if (si == null || si.length() == 0 || !si.equals("$(" + varname)) continue;
                    index = iinput;
                    break;
                }
            }
            if (index == -1) {
                errmessage.argvalue = "Undefined variable $" + varname;
                Dic.writeLog((String)errmessage.argvalue);
                return null;
            }
            begaddress = (int)positions.get(index).doubleValue();
            String sj = null;
            int reclevel = 0;
            for (indexend = index + 1; indexend < variables.size(); ++indexend) {
                sj = variables.get(indexend);
                if (sj == null || sj.length() == 0) continue;
                if (sj.charAt(0) == '$' && sj.length() > 2 && sj.charAt(1) == '(') {
                    ++reclevel;
                    continue;
                }
                if (sj.charAt(0) != '$' || sj.length() < 2 || sj.charAt(1) != ')') continue;
                if (reclevel == 0) break;
                --reclevel;
            }
            if (indexend >= positions.size()) {
                errmessage.argvalue = "No closing Parenthesis for variable " + varname;
                Dic.writeLog((String)errmessage.argvalue);
                return null;
            }
            endaddress = (int)positions.get(indexend).doubleValue();
            if (sj != null && sj.length() > 2) {
                String[] results = new String[]{sj.substring(2)};
                return results;
            }
        }
        if (varcompletename.length() == varname.length()) {
            String[] results;
            if (begaddress == endaddress) {
                results = new String[]{""};
                return results;
            }
            String res = text.substring(begaddress, endaddress).trim();
            results = new String[]{res};
            varvalues.argvalue = new ArrayList();
            HashMap<String, String> varvalue = new HashMap<String, String>();
            varvalue.put(varname, res);
            ((ArrayList)varvalues.argvalue).add(varvalue);
            String lex = null;
            for (int ii = index + 1; ii < indexend; ++ii) {
                String var = variables.get(ii);
                String entry = null;
                String lemma = null;
                String info = null;
                RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                RefObject<Object> tempRef_info = new RefObject<Object>(info);
                boolean tempVar = var != null && Dic.parseDELAF(var, tempRef_entry, tempRef_lemma, tempRef_info, null, null, null);
                entry = (String)tempRef_entry.argvalue;
                lemma = (String)tempRef_lemma.argvalue;
                info = (String)tempRef_info.argvalue;
                if (!tempVar) continue;
                lex = var;
                break;
            }
            if (lex != null) {
                varvalue.put("LU_" + varname, lex);
            }
            return results;
        }
        ArrayList<String[]> listofresults = new ArrayList<String[]>();
        String lex = null;
        for (int ii = index + 1; ii < indexend; ++ii) {
            String var = variables.get(ii);
            String entry = null;
            String lemma = null;
            String info = null;
            RefObject<Object> tempRef_entry2 = new RefObject<Object>(entry);
            RefObject<Object> tempRef_lemma2 = new RefObject<Object>(lemma);
            RefObject<Object> tempRef_info2 = new RefObject<Object>(info);
            boolean tempVar2 = var != null && Dic.parseDELAF(var, tempRef_entry2, tempRef_lemma2, tempRef_info2, null, null, null);
            entry = (String)tempRef_entry2.argvalue;
            lemma = (String)tempRef_lemma2.argvalue;
            info = (String)tempRef_info2.argvalue;
            if (!tempVar2) continue;
            lex = var;
            ArrayList<String> lexs = new ArrayList<String>();
            lexs.add(lex);
            String[] cresults = this.computeDerivations(varcompletename.substring(varname.length()), lexs, lan1);
            if (cresults == null) continue;
            listofresults.add(cresults);
        }
        if (listofresults.isEmpty()) {
            return null;
        }
        ArrayList<String> devlistofresults = this.recDevelop(listofresults, 0);
        String[] results = new String[devlistofresults.size()];
        varvalues.argvalue = new ArrayList();
        int i = 0;
        for (String res : devlistofresults) {
            results[i++] = res;
            HashMap<String, String> varvalue = new HashMap<String, String>();
            varvalue.put("LU_" + varname, lex);
            varvalue.put(varcompletename, res);
            ((ArrayList)varvalues.argvalue).add(varvalue);
        }
        return results;
    }

    private int getPositionIndex(String varcompletename, ArrayList<String> variables, int ipos) {
        String si;
        int iinput;
        int index1 = varcompletename.indexOf(95);
        int index2 = varcompletename.indexOf(36);
        int index = index1;
        if (index == -1) {
            index = index2;
        } else if (index2 == -1) {
            index = index1;
        } else if (index2 < index) {
            index = index2;
        }
        String varname = index == -1 ? varcompletename : varcompletename.substring(0, index);
        for (iinput = ipos; iinput >= 0; --iinput) {
            si = variables.get(iinput);
            if (si == null || si.length() == 0 || !si.equals("$(" + varname)) continue;
            return iinput;
        }
        for (iinput = ipos; iinput < variables.size(); ++iinput) {
            si = variables.get(iinput);
            if (si == null || si.length() == 0 || !si.equals("$(" + varname)) continue;
            return iinput;
        }
        return -1;
    }

    final String processVariableInMorphoLabel(String label, ArrayList<String> inputs) {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < label.length()) {
            String val;
            if (label.charAt(i) == '\\') {
                res.append(label.charAt(i));
                res.append(label.charAt(i + 1));
                i += 2;
                continue;
            }
            if (label.charAt(i) != '$') {
                res.append(label.charAt(i));
                ++i;
                continue;
            }
            if (i + 1 < label.length() && (label.charAt(i + 1) == '(' || label.charAt(i + 1) == ')')) {
                res.append(label.charAt(i));
                ++i;
                continue;
            }
            if (i + 1 < label.length() && (label.charAt(i + 1) == '>' || label.charAt(i + 1) == '}' || label.charAt(i + 1) == '$' || label.charAt(i + 1) == ',' || label.charAt(i + 1) == '=' || label.charAt(i + 1) == '#')) {
                res.append(label.charAt(i));
                ++i;
                continue;
            }
            ++i;
            int j = 0;
            while (i + j < label.length() && !Character.isWhitespace(label.charAt(i + j)) && label.charAt(i + j) != '#' && label.charAt(i + j) != '=' && label.charAt(i + j) != ',' && label.charAt(i + j) != '>' && label.charAt(i + j) != '}') {
                ++j;
            }
            String varname = label.toString().substring(i, i + j);
            if (i + j < label.length() && label.charAt(i + j) == '#') {
                ++j;
            }
            if ((val = this.getMorphoValue(varname, inputs)) == null || val.length() == 0) {
                res.append("*UNDEFINED*");
            } else {
                res.append(val);
            }
            i += j;
        }
        return res.toString();
    }

    final boolean thereIsAVariableInLabel(String label) {
        int i = 0;
        while (i < label.length()) {
            if (label.charAt(i) == '\\') {
                i += 2;
                continue;
            }
            if (label.charAt(i) == '\"') {
                ++i;
                while (i < label.length() && label.charAt(i) != '\"') {
                    ++i;
                }
                ++i;
                continue;
            }
            if (label.charAt(i) == '$') {
                if (i + 1 < label.length() && (label.charAt(i + 1) == '(' || label.charAt(i + 1) == ')')) {
                    ++i;
                    continue;
                }
                if (i + 1 < label.length() && label.charAt(i + 1) == '>') {
                    ++i;
                    continue;
                }
                return i + 1 != label.length();
            }
            ++i;
        }
        return false;
    }

    private String getLexFromVariable(ArrayList<String> variable, int pos1) {
        for (int i = pos1 + 1; i < variable.size(); ++i) {
            String line = null;
            String entry = null;
            String lemma = null;
            String info = null;
            line = variable.get(i);
            if (line == null || line.equals("")) continue;
            int level = 1;
            if (line.length() > 2 && line.charAt(0) == '$' && line.charAt(1) == '(') {
                ++level;
            } else if (line.length() >= 2 && line.charAt(0) == '$' && line.charAt(1) == ')' && --level == 0) {
                return null;
            }
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
            RefObject<Object> tempRef_info = new RefObject<Object>(info);
            boolean tempVar = Dic.parseDELAF(line, tempRef_entry, tempRef_lemma, tempRef_info, null, null, null);
            entry = (String)tempRef_entry.argvalue;
            lemma = (String)tempRef_lemma.argvalue;
            info = (String)tempRef_info.argvalue;
            if (!tempVar) continue;
            return line;
        }
        return null;
    }

    private final boolean processConstraint(String current, Mft textmft, int tunb, ArrayList<Object> annotations, Grammar grammar, ArrayList<Double> position, int rightmargin, ArrayList<String> variable, double cpos, int ipos, String so, RefObject<ArrayList<String>> sols, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        boolean negation;
        RefObject<Boolean> tempRef_negation;
        String op;
        RefObject<Object> tempRef_op;
        String[] features;
        RefObject<Object> tempRef_features;
        String category;
        RefObject<Object> tempRef_category;
        String lemma;
        RefObject<Object> tempRef_lemma;
        String left;
        RefObject<Object> tempRef_left;
        ParameterCheck.mandatory("grammar", grammar);
        ParameterCheck.mandatoryString("so", so);
        ParameterCheck.mandatory("sols", sols);
        ParameterCheck.mandatory("errmessage", errmessage);
        sols.argvalue = null;
        int pos1 = -1;
        int pos2 = -1;
        Language lan1 = null;
        String[] str1 = null;
        String[] str2 = null;
        boolean compound1 = false;
        boolean compound2 = false;
        errmessage.argvalue = null;
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < so.length()) {
            if (so.charAt(i) == '\\') {
                res.append(so.charAt(i));
                res.append(so.charAt(i + 1));
                i += 2;
                continue;
            }
            if (so.charAt(i) != '$') {
                res.append(so.charAt(i));
                ++i;
                continue;
            }
            int j = 0;
            RefObject<Integer> tempRef_j = new RefObject<Integer>(j);
            String varname = Dic.getFullVariableName(so, i, tempRef_j);
            i = j = ((Integer)tempRef_j.argvalue).intValue();
            int vpos = this.getPositionIndex(varname, variable, ipos);
            if (vpos == -1) {
                pos1 = -2;
                errmessage.argvalue = "$" + varname + " is undefined";
                res.append("*UNDEFINED*");
                continue;
            }
            if (pos1 == -1) {
                pos1 = vpos;
                RefObject<Boolean> tempRef_compound1 = new RefObject<Boolean>(compound1);
                RefObject<Object> tempRef_lan1 = new RefObject<Object>(lan1);
                str1 = this.GetValues(current, varname, tempRef_compound1, position, rightmargin, variable, cpos, pos1, tempRef_lan1, textmft, annotations, tunb, null, null);
                compound1 = (Boolean)tempRef_compound1.argvalue;
                lan1 = (Language)tempRef_lan1.argvalue;
                if (str1 == null) {
                    res.append("*UNDEFINED*");
                    errmessage.argvalue = "$" + varname + " has no value";
                    Dic.writeLog((String)errmessage.argvalue);
                    continue;
                }
                res.append(str1[0]);
                continue;
            }
            pos2 = vpos;
            RefObject<Boolean> tempRef_compound2 = new RefObject<Boolean>(compound2);
            RefObject<Object> tempRef_lan12 = new RefObject<Object>(lan1);
            str2 = this.GetValues(current, varname, tempRef_compound2, position, rightmargin, variable, cpos, pos2, tempRef_lan12, textmft, annotations, tunb, null, null);
            compound2 = (Boolean)tempRef_compound2.argvalue;
            lan1 = (Language)tempRef_lan12.argvalue;
            if (str2 == null) {
                res.append("*UNDEFINED*");
                errmessage.argvalue = "$" + varname + " has no value";
                Dic.writeLog((String)errmessage.argvalue);
                continue;
            }
            res.append(str2[0]);
        }
        String constraint = res.toString();
        boolean tempVar = !Dic.parseLexicalConstraint(constraint, tempRef_left = new RefObject<Object>((left = null)), tempRef_lemma = new RefObject<Object>((lemma = null)), tempRef_category = new RefObject<Object>((category = null)), tempRef_features = new RefObject<Object>((features = null)), tempRef_op = new RefObject<Object>((op = null)), tempRef_negation = new RefObject<Boolean>(negation = false));
        left = (String)tempRef_left.argvalue;
        lemma = (String)tempRef_lemma.argvalue;
        category = (String)tempRef_category.argvalue;
        features = (String[])tempRef_features.argvalue;
        op = (String)tempRef_op.argvalue;
        negation = (Boolean)tempRef_negation.argvalue;
        if (tempVar) {
            return false;
        }
        if (op.equals("=:")) {
            if (pos1 == -1) {
                errmessage.argvalue = "no variable";
                Dic.writeLog((String)errmessage.argvalue);
                return false;
            }
            sols.argvalue = new ArrayList();
            if (lan1 == null) {
                if (pos2 == -1) {
                    if (!compound1) {
                        String lex = this.getLexFromVariable(variable, pos1);
                        if (lex == null || lex.indexOf(",WF") != -1) {
                            for (int istr = 0; istr < str1.length; ++istr) {
                                ArrayList<String> tsols = this.lookup(-2, str1[istr], false, null, -2, errmessage);
                                if (errmessage.argvalue != null) {
                                    return false;
                                }
                                if (tsols == null || tsols.size() <= 0) continue;
                                ((ArrayList)sols.argvalue).addAll(tsols);
                            }
                        } else {
                            ((ArrayList)sols.argvalue).add(lex);
                        }
                    } else {
                        for (int istr = 0; istr < str1.length; ++istr) {
                            ArrayList<String> tsols = this.lookup(-2, str1[istr], false, null, -2, errmessage);
                            if (errmessage.argvalue != null) {
                                return false;
                            }
                            if (tsols == null || tsols.size() <= 0) continue;
                            ((ArrayList)sols.argvalue).addAll(tsols);
                        }
                    }
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (int ileft = 0; ileft < left.length(); ++ileft) {
                        if (left.charAt(ileft) == '#') continue;
                        sb.append(left.charAt(ileft));
                    }
                    String word = sb.toString();
                    ArrayList<String> tsols = this.lookup(-2, word, false, null, -2, errmessage);
                    if (errmessage.argvalue != null) {
                        return false;
                    }
                    if (tsols != null && tsols.size() > 0) {
                        ((ArrayList)sols.argvalue).addAll(tsols);
                    }
                }
            } else {
                if (this.engine2 == null || !this.engine2.Lan.isoName.equals(lan1.isoName)) {
                    RefObject<Language> tempRef_lan13 = new RefObject<Language>(lan1);
                    this.engine2 = new Engine(tempRef_lan13, this.applicationDir, this.docDir, this.projectDir, this.projectMode, this.preferences, this.BackgroundWorking, this.backgroundWorker);
                    lan1 = (Language)tempRef_lan13.argvalue;
                    if (this.engine2.loadResources(this.preferences.ldic.get(lan1.isoName), null, false, errmessage)) {
                        errmessage.argvalue = "no linguistic resource for " + lan1.isoName;
                        Dic.writeLog((String)errmessage.argvalue);
                        return false;
                    }
                }
                sols.argvalue = new ArrayList();
                for (int istr = 0; istr < str1.length; ++istr) {
                    ArrayList<String> tsols = this.engine2.lookup(-2, str1[istr], false, null, -2, errmessage);
                    if (errmessage.argvalue != null) {
                        errmessage.argvalue = "no lexical entry for " + str1[istr];
                        Dic.writeLog((String)errmessage.argvalue);
                        return false;
                    }
                    if (tsols == null || tsols.size() <= 0) continue;
                    ((ArrayList)sols.argvalue).addAll(tsols);
                }
                for (int isol = 0; isol < ((ArrayList)sols.argvalue).size(); ++isol) {
                    String si = (String)((ArrayList)sols.argvalue).get(isol);
                    int jsol = isol + 1;
                    while (jsol < ((ArrayList)sols.argvalue).size()) {
                        String sj = (String)((ArrayList)sols.argvalue).get(jsol);
                        if (si.equals(sj)) {
                            ((ArrayList)sols.argvalue).remove(jsol);
                            continue;
                        }
                        ++jsol;
                    }
                }
            }
            if (sols.argvalue == null || ((ArrayList)sols.argvalue).isEmpty()) {
                return negation;
            }
            grammar.filterLexemes(sols, lemma, category, features, negation);
            if (sols.argvalue == null || ((ArrayList)sols.argvalue).isEmpty()) {
                errmessage.argvalue = constraint + " failed";
                return negation;
            }
            return !negation;
        }
        if (op.equals("=")) {
            if (str1 == null) {
                str1 = new String[]{"*UNDEFINED*"};
            }
            if (str2 == null) {
                str2 = new String[]{lemma};
            }
            boolean thereisamatch = false;
            block7: for (int uu = 0; uu < 1; ++uu) {
                if (str1 == null) continue;
                for (String s1 : str1) {
                    if (str2 == null) continue;
                    Collator collator = Collator.getInstance(this.Lan.locale);
                    for (String s2 : str2) {
                        if (s2 != null && s2.length() >= 2 && s2.charAt(0) == '\"' && s2.charAt(s2.length() - 1) == '\"') {
                            String s22 = s2.substring(1, 1 + s2.length() - 2);
                            if (!(s1.length() == 0 && s22.length() == 0 || Character.isUpperCase(s22.charAt(0)) && collator.compare(s1, s22) == 0) && (Character.isUpperCase(s22.charAt(0)) || collator.compare(s1.toLowerCase(this.Lan.locale), s22.toLowerCase(this.Lan.locale)) != 0)) continue;
                            thereisamatch = true;
                            break block7;
                        }
                        if (!(s1.length() == 0 && s2.length() == 0 || Character.isUpperCase(s2.charAt(0)) && collator.compare(s1, s2) == 0) && (Character.isUpperCase(s2.charAt(0)) || collator.compare(s1.toLowerCase(this.Lan.locale), s2.toLowerCase(this.Lan.locale)) != 0)) continue;
                        thereisamatch = true;
                        break block7;
                    }
                }
            }
            if (thereisamatch) {
                return !negation;
            }
            errmessage.argvalue = constraint + " failed";
            return negation;
        }
        if (op.equals("!=")) {
            if (str1 == null) {
                str1 = new String[]{"*UNDEFINED*"};
            }
            if (str2 == null) {
                str2 = new String[]{lemma};
            }
            boolean thereisamatch = false;
            Collator collator = Collator.getInstance(this.Lan.locale);
            block10: for (String s1 : str1) {
                for (String s2 : str2) {
                    if (s1.length() == 0 && s2.length() == 0 || Character.isUpperCase(s2.charAt(0)) && collator.compare(s1, s2) == 0 || !Character.isUpperCase(s2.charAt(0)) && collator.compare(s1.toLowerCase(this.Lan.locale), s2.toLowerCase(this.Lan.locale)) == 0) continue;
                    thereisamatch = true;
                    break block10;
                }
            }
            if (thereisamatch) {
                return !negation;
            }
            errmessage.argvalue = constraint + " failed";
            return negation;
        }
        errmessage.argvalue = "operator '" + op + "' unknown in constraint '" + constraint + "'";
        Dic.writeLog((String)errmessage.argvalue);
        return false;
    }

    private final boolean ProcessVariablesInString(String currentline, double cpos, int ipos, Mft textmft, int rightmargin, ArrayList<Object> annotations, int tunb, ArrayList<Double> positiontrace, ArrayList<String> variabletrace, String soutput, Grammar grammar, RefObject<ArrayList<String>> resoutputs, RefObject<ArrayList<HashMap<String, String>>> resvariables, int recindex) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatoryString("soutput", soutput);
        ParameterCheck.mandatory("resoutputs", resoutputs);
        if (recindex >= soutput.length()) {
            resoutputs.argvalue = new ArrayList();
            ((ArrayList)resoutputs.argvalue).add("");
            return true;
        }
        ArrayList tailoutputs = null;
        if (soutput.charAt(recindex) != '$') {
            int iso;
            StringBuilder sb = new StringBuilder();
            for (iso = recindex; iso < soutput.length() && soutput.charAt(iso) != '$'; ++iso) {
                if (soutput.charAt(iso) == '#') continue;
                sb.append(soutput.charAt(iso));
            }
            String curoutput = sb.toString();
            RefObject<Object> tempRef_tailoutputs = new RefObject<Object>(tailoutputs);
            boolean res = this.ProcessVariablesInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs, resvariables, iso);
            tailoutputs = (ArrayList)tempRef_tailoutputs.argvalue;
            if (!res) {
                resoutputs.argvalue = null;
                return false;
            }
            if (tailoutputs == null) {
                resoutputs.argvalue = null;
                return true;
            }
            resoutputs.argvalue = new ArrayList();
            for (int i2 = 0; i2 < tailoutputs.size(); ++i2) {
                String aresoutput = curoutput + (String)tailoutputs.get(i2);
                ((ArrayList)resoutputs.argvalue).add(aresoutput);
            }
            return true;
        }
        int j = 0;
        RefObject<Integer> tempRef_j = new RefObject<Integer>(j);
        String varname = Dic.getFullVariableName(soutput, recindex, tempRef_j);
        int iso = j = ((Integer)tempRef_j.argvalue).intValue();
        ArrayList<Object> curoutputs = new ArrayList<Object>();
        ArrayList newresvariables = new ArrayList();
        for (int ivars = 0; ivars < ((ArrayList)resvariables.argvalue).size(); ++ivars) {
            HashMap hvariables = (HashMap)((ArrayList)resvariables.argvalue).get(ivars);
            if (hvariables.containsKey(varname)) {
                newresvariables.add(hvariables);
                curoutputs.add(hvariables.get(varname));
                continue;
            }
            if (variabletrace == null) continue;
            Language lan1 = null;
            boolean compoundvariable = false;
            ArrayList curvars = null;
            String errmessage = null;
            RefObject<Boolean> tempRef_compoundvariable = new RefObject<Boolean>(compoundvariable);
            RefObject<Object> tempRef_lan1 = new RefObject<Object>(lan1);
            RefObject<Object> tempRef_curvars = new RefObject<Object>(curvars);
            RefObject<Object> tempRef_errmessage = new RefObject<Object>(errmessage);
            String[] tmpoutputs = this.GetValues(currentline, varname, tempRef_compoundvariable, positiontrace, rightmargin, variabletrace, cpos, ipos, tempRef_lan1, textmft, annotations, tunb, tempRef_curvars, tempRef_errmessage);
            compoundvariable = (Boolean)tempRef_compoundvariable.argvalue;
            lan1 = (Language)tempRef_lan1.argvalue;
            curvars = (ArrayList)tempRef_curvars.argvalue;
            errmessage = (String)tempRef_errmessage.argvalue;
            if (tmpoutputs == null || curvars == null) {
                if (errmessage == null) continue;
                System.out.println(errmessage);
                continue;
            }
            for (int jvars = 0; jvars < curvars.size(); ++jvars) {
                String tmpoutput = tmpoutputs[jvars];
                curoutputs.add(tmpoutput);
                HashMap newhvariables = new HashMap(hvariables);
                HashMap curvar = (HashMap)curvars.get(jvars);
                newhvariables.put(varname, curvar.get(varname));
                if (curvar.containsKey("LU_" + varname)) {
                    newhvariables.put("LU_" + varname, curvar.get("LU_" + varname));
                }
                newresvariables.add(newhvariables);
            }
        }
        if (newresvariables.isEmpty()) {
            resoutputs.argvalue = null;
            return false;
        }
        resvariables.argvalue = newresvariables;
        RefObject<ArrayList<String>> tempRef_tailoutputs3 = new RefObject<ArrayList<String>>(tailoutputs);
        boolean res = this.ProcessVariablesInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs3, resvariables, iso);
        tailoutputs = (ArrayList)tempRef_tailoutputs3.argvalue;
        if (!res) {
            resoutputs.argvalue = null;
            return false;
        }
        if (tailoutputs == null) {
            resoutputs.argvalue = null;
            return true;
        }
        resoutputs.argvalue = new ArrayList();
        for (int icur = 0; icur < curoutputs.size(); ++icur) {
            String curoutput = (String)curoutputs.get(icur);
            for (int itail = 0; itail < tailoutputs.size(); ++itail) {
                String sres = curoutput + (String)tailoutputs.get(itail);
                ((ArrayList)resoutputs.argvalue).add(sres);
            }
        }
        return true;
    }

    private boolean pureVariable(String left) {
        int j;
        ParameterCheck.mandatoryString("left", left);
        if (left.length() == 0) {
            return false;
        }
        if (left.charAt(0) != '$') {
            return false;
        }
        for (j = 1; j < left.length() && !Character.isWhitespace(left.charAt(j)) && left.charAt(j) != '#' && left.charAt(j) != '=' && left.charAt(j) != ',' && left.charAt(j) != '>'; ++j) {
        }
        return j >= left.length();
    }

    private boolean SolveConstraint(String originalleft, ArrayList<String> leftstrings, ArrayList<String> rightstrings, String nop, boolean negation, Grammar grammar, RefObject<ArrayList<String>> curoutputs, RefObject<ArrayList<HashMap<String, String>>> resvariables, RefObject<String> errmessage) {
        ParameterCheck.mandatory("leftstrings", leftstrings);
        ParameterCheck.mandatory("rightstrings", rightstrings);
        ParameterCheck.mandatory("nop", nop);
        ParameterCheck.mandatory("grammar", grammar);
        ParameterCheck.mandatory("resvariables", resvariables);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        Collator collator = Collator.getInstance(this.Lan.locale);
        if (nop.equals("=")) {
            boolean match = false;
            block0: for (String left : leftstrings) {
                for (String right : rightstrings) {
                    String info;
                    String lemma;
                    String entry;
                    boolean tempVarL = left.length() >= 2 && left.charAt(0) == '<' && left.charAt(left.length() - 1) == '>' ? Dic.parseDELAF(left.substring(1, 1 + left.length() - 2), null, null, null, null, null, null) : false;
                    boolean tempVarR = left.length() >= 2 && left.charAt(0) == '<' && left.charAt(left.length() - 1) == '>' ? Dic.parseDELAF(left.substring(1, 1 + left.length() - 2), null, null, null, null, null, null) : false;
                    if (tempVarL && !tempVarR) {
                        entry = null;
                        lemma = null;
                        info = null;
                        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                        RefObject<Object> tempRef_info = new RefObject<Object>(info);
                        Dic.parseLexemeSymbol(left, tempRef_entry, tempRef_lemma, null, null, tempRef_info);
                        entry = (String)tempRef_entry.argvalue;
                        lemma = (String)tempRef_lemma.argvalue;
                        info = (String)tempRef_info.argvalue;
                        if (!(left.length() == 0 && entry.length() == 0 || Character.isUpperCase(entry.charAt(0)) && collator.compare(left, entry) == 0) && (Character.isUpperCase(entry.charAt(0)) || collator.compare(left.toLowerCase(this.Lan.locale), entry.toLowerCase(this.Lan.locale)) != 0)) continue;
                        match = true;
                        continue block0;
                    }
                    if (!tempVarL && tempVarR) {
                        entry = null;
                        lemma = null;
                        info = null;
                        RefObject<Object> tempRef_entry2 = new RefObject<Object>(entry);
                        RefObject<Object> tempRef_lemma2 = new RefObject<Object>(lemma);
                        RefObject<Object> tempRef_info2 = new RefObject<Object>(info);
                        Dic.parseLexemeSymbol(right, tempRef_entry2, tempRef_lemma2, null, null, tempRef_info2);
                        entry = (String)tempRef_entry2.argvalue;
                        lemma = (String)tempRef_lemma2.argvalue;
                        info = (String)tempRef_info2.argvalue;
                        if (!(left.length() == 0 && entry.length() == 0 || Character.isUpperCase(entry.charAt(0)) && collator.compare(left, entry) == 0) && (Character.isUpperCase(entry.charAt(0)) || collator.compare(left.toLowerCase(this.Lan.locale), entry.toLowerCase(this.Lan.locale)) != 0)) continue;
                        match = true;
                        continue block0;
                    }
                    if (!(left.length() == 0 && right.length() == 0 || Character.isUpperCase(right.charAt(0)) && collator.compare(left, right) == 0) && (Character.isUpperCase(right.charAt(0)) || collator.compare(left.toLowerCase(this.Lan.locale), right.toLowerCase(this.Lan.locale)) != 0)) continue;
                    match = true;
                    continue block0;
                }
            }
            if (match) {
                curoutputs.argvalue = new ArrayList();
                ((ArrayList)curoutputs.argvalue).add("");
                return !negation;
            }
            curoutputs.argvalue = null;
            return negation;
        }
        if (nop.equals("!=")) {
            boolean match = false;
            block2: for (String left : leftstrings) {
                for (String right : rightstrings) {
                    String info;
                    String lemma;
                    String entry;
                    boolean tempVarL = left.length() >= 2 && left.charAt(0) == '<' && left.charAt(left.length() - 1) == '>' ? Dic.parseDELAF(left.substring(1, 1 + left.length() - 2), null, null, null, null, null, null) : false;
                    boolean tempVarR = left.length() >= 2 && left.charAt(0) == '<' && left.charAt(left.length() - 1) == '>' ? Dic.parseDELAF(left.substring(1, 1 + left.length() - 2), null, null, null, null, null, null) : false;
                    if (tempVarL && !tempVarR) {
                        entry = null;
                        lemma = null;
                        info = null;
                        RefObject<Object> tempRef_entry3 = new RefObject<Object>(entry);
                        RefObject<Object> tempRef_lemma3 = new RefObject<Object>(lemma);
                        RefObject<Object> tempRef_info3 = new RefObject<Object>(info);
                        Dic.parseLexemeSymbol(left, tempRef_entry3, tempRef_lemma3, null, null, tempRef_info3);
                        entry = (String)tempRef_entry3.argvalue;
                        lemma = (String)tempRef_lemma3.argvalue;
                        info = (String)tempRef_info3.argvalue;
                        if (!(left.length() == 0 && entry.length() == 0 || Character.isUpperCase(entry.charAt(0)) && collator.compare(left, entry) == 0) && (Character.isUpperCase(entry.charAt(0)) || collator.compare(left.toLowerCase(this.Lan.locale), entry.toLowerCase(this.Lan.locale)) != 0)) continue;
                        match = true;
                        continue block2;
                    }
                    if (!tempVarL && tempVarR) {
                        entry = null;
                        lemma = null;
                        info = null;
                        RefObject<Object> tempRef_entry4 = new RefObject<Object>(entry);
                        RefObject<Object> tempRef_lemma4 = new RefObject<Object>(lemma);
                        RefObject<Object> tempRef_info4 = new RefObject<Object>(info);
                        Dic.parseLexemeSymbol(right, tempRef_entry4, tempRef_lemma4, null, null, tempRef_info4);
                        entry = (String)tempRef_entry4.argvalue;
                        lemma = (String)tempRef_lemma4.argvalue;
                        info = (String)tempRef_info4.argvalue;
                        if (!(left.length() == 0 && entry.length() == 0 || Character.isUpperCase(entry.charAt(0)) && collator.compare(left, entry) == 0) && (Character.isUpperCase(entry.charAt(0)) || collator.compare(left.toLowerCase(this.Lan.locale), entry.toLowerCase(this.Lan.locale)) != 0)) continue;
                        match = true;
                        continue block2;
                    }
                    if (!(left.length() == 0 && right.length() == 0 || Character.isUpperCase(right.charAt(0)) && collator.compare(left, right) == 0) && (Character.isUpperCase(right.charAt(0)) || collator.compare(left.toLowerCase(this.Lan.locale), right.toLowerCase(this.Lan.locale)) != 0)) continue;
                    match = true;
                    continue block2;
                }
            }
            if (!match) {
                curoutputs.argvalue = new ArrayList();
                ((ArrayList)curoutputs.argvalue).add("");
                return !negation;
            }
            curoutputs.argvalue = null;
            return negation;
        }
        if (nop.equals("=:")) {
            if (this.pureVariable(originalleft)) {
                ArrayList sols = new ArrayList();
                for (int ilex = 0; ilex < ((ArrayList)resvariables.argvalue).size(); ++ilex) {
                    Iterator vals = (HashMap)((ArrayList)resvariables.argvalue).get(ilex);
                    if (originalleft.length() <= 1 || originalleft.charAt(0) != '$' || !((HashMap)((Object)vals)).containsKey("LU_" + originalleft.substring(1))) continue;
                    String lexeme = (String)((HashMap)((Object)vals)).get("LU_" + originalleft.substring(1));
                    sols.add(lexeme);
                }
                if (sols.isEmpty()) {
                    curoutputs.argvalue = null;
                    return negation;
                }
                boolean amatch = false;
                for (String right : rightstrings) {
                    ArrayList tsols = new ArrayList(sols);
                    String category = null;
                    String lemma = null;
                    String[] features = null;
                    boolean negation2 = false;
                    RefObject<Object> tempRef_lemma5 = new RefObject<Object>(lemma);
                    RefObject<Object> tempRef_category = new RefObject<Object>(category);
                    RefObject<Object> tempRef_features = new RefObject<Object>(features);
                    RefObject<Boolean> tempRef_negation2 = new RefObject<Boolean>(negation2);
                    Dic.parseLexicalConstraintRightSide(right, tempRef_lemma5, tempRef_category, tempRef_features, tempRef_negation2);
                    lemma = (String)tempRef_lemma5.argvalue;
                    category = (String)tempRef_category.argvalue;
                    features = (String[])tempRef_features.argvalue;
                    negation2 = (Boolean)tempRef_negation2.argvalue;
                    RefObject<ArrayList<String>> tempRef_tsols = new RefObject<ArrayList<String>>(tsols);
                    grammar.filterLexemes(tempRef_tsols, lemma, category, features, negation && !negation2 || !negation && negation2);
                    tsols = (ArrayList)tempRef_tsols.argvalue;
                    if (tsols == null || tsols.size() <= 0) continue;
                    sols = tsols;
                    amatch = true;
                    break;
                }
                if (!amatch) {
                    curoutputs.argvalue = null;
                    return negation;
                }
                curoutputs.argvalue = new ArrayList();
                for (String lex : sols) {
                    ((ArrayList)curoutputs.argvalue).add("<LU=" + lex + ">");
                }
                return !negation;
            }
            curoutputs.argvalue = new ArrayList();
            ArrayList sols = new ArrayList();
            for (String left : leftstrings) {
                ArrayList tsols = this.lookup(-2, left, false, null, -2, errmessage);
                if (errmessage.argvalue != null) {
                    return false;
                }
                if (tsols == null || tsols.isEmpty()) continue;
                boolean amatch = false;
                for (String right : rightstrings) {
                    ArrayList tsols2 = new ArrayList(tsols);
                    String category = null;
                    String lemma = null;
                    String[] features = null;
                    boolean negation2 = false;
                    RefObject<Object> tempRef_lemma6 = new RefObject<Object>(lemma);
                    RefObject<Object> tempRef_category2 = new RefObject<Object>(category);
                    RefObject<Object> tempRef_features2 = new RefObject<Object>(features);
                    RefObject<Boolean> tempRef_negation22 = new RefObject<Boolean>(negation2);
                    Dic.parseLexicalConstraintRightSide(right, tempRef_lemma6, tempRef_category2, tempRef_features2, tempRef_negation22);
                    lemma = (String)tempRef_lemma6.argvalue;
                    category = (String)tempRef_category2.argvalue;
                    features = (String[])tempRef_features2.argvalue;
                    negation2 = (Boolean)tempRef_negation22.argvalue;
                    RefObject<ArrayList<String>> tempRef_tsols2 = new RefObject<ArrayList<String>>(tsols2);
                    grammar.filterLexemes(tempRef_tsols2, lemma, category, features, negation && !negation2 || !negation && negation2);
                    tsols2 = (ArrayList)tempRef_tsols2.argvalue;
                    if (tsols2 == null || tsols2.size() <= 0) continue;
                    tsols = tsols2;
                    amatch = true;
                    break;
                }
                if (!amatch) continue;
                sols.addAll(tsols);
            }
            for (String lex : sols) {
                ((ArrayList)curoutputs.argvalue).add("<LU=" + lex + ">");
            }
            return !negation;
        }
        curoutputs.argvalue = null;
        return false;
    }

    private boolean SolveConstraintForTransformed(String originalleft, ArrayList<String> leftstrings, ArrayList<String> rightstrings, String nop, boolean negation, Grammar grammar, RefObject<ArrayList<HashMap<String, String>>> resvariables, RefObject<String> errmessage) {
        ParameterCheck.mandatory("leftstrings", leftstrings);
        ParameterCheck.mandatory("rightstrings", rightstrings);
        ParameterCheck.mandatory("nop", nop);
        ParameterCheck.mandatory("grammar", grammar);
        ParameterCheck.mandatory("resvariables", resvariables);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        if (nop.equals("=")) {
            boolean match = false;
            String res = null;
            block0: for (String left : leftstrings) {
                for (String right : rightstrings) {
                    if (!left.equals(right)) continue;
                    match = true;
                    res = left;
                    continue block0;
                }
            }
            if (match) {
                return !negation;
            }
            return negation;
        }
        if (nop.equals("!=")) {
            boolean match = false;
            String res = null;
            block2: for (String left : leftstrings) {
                for (String right : rightstrings) {
                    if (left.equals(right)) {
                        match = true;
                        continue block2;
                    }
                    res = left;
                }
            }
            if (!match) {
                return !negation;
            }
            return negation;
        }
        if (nop.equals("=:")) {
            if (this.pureVariable(originalleft)) {
                ArrayList sols = new ArrayList();
                for (int ilex = 0; ilex < ((ArrayList)resvariables.argvalue).size(); ++ilex) {
                    HashMap vals = (HashMap)((ArrayList)resvariables.argvalue).get(ilex);
                    if (originalleft.length() <= 1 || originalleft.charAt(0) != '$' || !vals.containsKey(originalleft.substring(1))) continue;
                    String lexeme = (String)vals.get(originalleft.substring(1));
                    sols.add(lexeme.substring(1, 1 + lexeme.length() - 2));
                }
                if (sols.isEmpty()) {
                    return negation;
                }
                boolean amatch = false;
                for (String right : rightstrings) {
                    ArrayList tsols = (ArrayList)sols.clone();
                    String category = null;
                    String lemma = null;
                    String[] features = null;
                    boolean negation2 = false;
                    RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                    RefObject<Object> tempRef_category = new RefObject<Object>(category);
                    RefObject<Object> tempRef_features = new RefObject<Object>(features);
                    RefObject<Boolean> tempRef_negation2 = new RefObject<Boolean>(negation2);
                    Dic.parseLexicalConstraintRightSide(right, tempRef_lemma, tempRef_category, tempRef_features, tempRef_negation2);
                    lemma = (String)tempRef_lemma.argvalue;
                    category = (String)tempRef_category.argvalue;
                    features = (String[])tempRef_features.argvalue;
                    negation2 = (Boolean)tempRef_negation2.argvalue;
                    RefObject<ArrayList<String>> tempRef_tsols = new RefObject<ArrayList<String>>(tsols);
                    grammar.filterLexemes(tempRef_tsols, lemma, category, features, negation && !negation2 || !negation && negation2);
                    tsols = (ArrayList)tempRef_tsols.argvalue;
                    if (tsols == null || tsols.size() <= 0) continue;
                    sols = tsols;
                    amatch = true;
                    break;
                }
                if (!amatch) {
                    return negation;
                }
                return !negation;
            }
            ArrayList sols = new ArrayList();
            for (String left : leftstrings) {
                ArrayList tsols = this.lookup(-2, left, false, null, -2, errmessage);
                if (errmessage.argvalue != null) {
                    return false;
                }
                if (tsols == null || tsols.isEmpty()) continue;
                boolean amatch = false;
                for (String right : rightstrings) {
                    ArrayList tsols2 = (ArrayList)tsols.clone();
                    String category = null;
                    String lemma = null;
                    String[] features = null;
                    boolean negation2 = false;
                    RefObject<Object> tempRef_lemma2 = new RefObject<Object>(lemma);
                    RefObject<Object> tempRef_category2 = new RefObject<Object>(category);
                    RefObject<Object> tempRef_features2 = new RefObject<Object>(features);
                    RefObject<Boolean> tempRef_negation22 = new RefObject<Boolean>(negation2);
                    Dic.parseLexicalConstraintRightSide(right, tempRef_lemma2, tempRef_category2, tempRef_features2, tempRef_negation22);
                    lemma = (String)tempRef_lemma2.argvalue;
                    category = (String)tempRef_category2.argvalue;
                    features = (String[])tempRef_features2.argvalue;
                    negation2 = (Boolean)tempRef_negation22.argvalue;
                    RefObject<ArrayList<String>> tempRef_tsols2 = new RefObject<ArrayList<String>>(tsols2);
                    grammar.filterLexemes(tempRef_tsols2, lemma, category, features, negation && !negation2 || !negation && negation2);
                    tsols2 = (ArrayList)tempRef_tsols2.argvalue;
                    if (tsols2 == null || tsols2.size() <= 0) continue;
                    tsols = tsols2;
                    amatch = true;
                    break;
                }
                if (!amatch) continue;
                sols.addAll(tsols);
            }
            if (sols.isEmpty()) {
                return negation;
            }
            return !negation;
        }
        return false;
    }

    private boolean ProcessSingleVariableInString(HashMap<String, String> hvariables, String currentline, double cpos, int ipos, Mft textmft, int rightmargin, ArrayList<Object> annotations, int tunb, ArrayList<Double> positiontrace, ArrayList<String> variabletrace, String soutput, Grammar grammar, RefObject<ArrayList<String>> resoutputs, RefObject<ArrayList<HashMap<String, String>>> resvariables, int recindex, RefObject<Integer> iso) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatory("resoutputs", resoutputs);
        ParameterCheck.mandatory("resvariables", resvariables);
        ParameterCheck.mandatory("iso", iso);
        resoutputs.argvalue = new ArrayList();
        int j = 0;
        RefObject<Integer> tempRef_j = new RefObject<Integer>(j);
        String varname = Dic.getFullVariableName(soutput, recindex, tempRef_j);
        j = (Integer)tempRef_j.argvalue;
        iso.argvalue = j;
        if (resvariables == null) {
            if (hvariables.containsKey(varname)) {
                ((ArrayList)resoutputs.argvalue).add(hvariables.get(varname));
                return true;
            }
            Object errmessage = null;
            RefObject<Object> tempRef_errmessage = new RefObject<Object>(errmessage);
            tempRef_errmessage.argvalue = varname + " undefined";
            return false;
        }
        ArrayList newresvariables = new ArrayList();
        for (int ivars = 0; ivars < ((ArrayList)resvariables.argvalue).size(); ++ivars) {
            hvariables = (HashMap)((ArrayList)resvariables.argvalue).get(ivars);
            if (hvariables.containsKey(varname)) {
                newresvariables.add(hvariables);
                ((ArrayList)resoutputs.argvalue).add(hvariables.get(varname));
                continue;
            }
            Language lan1 = null;
            boolean compoundvariable = false;
            ArrayList curvars = null;
            String errmessage = null;
            RefObject<Boolean> tempRef_compoundvariable = new RefObject<Boolean>(compoundvariable);
            RefObject<Object> tempRef_lan1 = new RefObject<Object>(lan1);
            RefObject<Object> tempRef_curvars = new RefObject<Object>(curvars);
            RefObject<Object> tempRef_errmessage = new RefObject<Object>(errmessage);
            String[] tmpoutputs = this.GetValues(currentline, varname, tempRef_compoundvariable, positiontrace, rightmargin, variabletrace, cpos, ipos, tempRef_lan1, textmft, annotations, tunb, tempRef_curvars, tempRef_errmessage);
            compoundvariable = (Boolean)tempRef_compoundvariable.argvalue;
            lan1 = (Language)tempRef_lan1.argvalue;
            curvars = (ArrayList)tempRef_curvars.argvalue;
            errmessage = (String)tempRef_errmessage.argvalue;
            if (tmpoutputs == null) continue;
            for (int jvars = 0; jvars < curvars.size(); ++jvars) {
                String tmpoutput = tmpoutputs[jvars];
                ((ArrayList)resoutputs.argvalue).add(tmpoutput);
                HashMap newhvariables = new HashMap(hvariables);
                HashMap curvar = (HashMap)curvars.get(jvars);
                if (varname.length() < 4 || varname.length() == 4 && !varname.equals("THIS") || varname.length() > 4 && !varname.substring(0, 4).equals("THIS")) {
                    newhvariables.put(varname, curvar.get(varname));
                    if (curvar.containsKey("LU_" + varname)) {
                        newhvariables.put("LU_" + varname, curvar.get("LU_" + varname));
                    }
                }
                newresvariables.add(newhvariables);
            }
        }
        resvariables.argvalue = newresvariables;
        return ((ArrayList)resvariables.argvalue).size() > 0;
    }

    private final boolean ProcessVariablesInString(String soutput, HashMap<String, String> hvariables, int recindex, RefObject<ArrayList<String>> resoutputs) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatoryString("soutput", soutput);
        ParameterCheck.mandatory("resoutputs", resoutputs);
        if (recindex >= soutput.length()) {
            resoutputs.argvalue = new ArrayList();
            ((ArrayList)resoutputs.argvalue).add("");
            return true;
        }
        ArrayList tailoutputs = null;
        if (soutput.charAt(recindex) != '$') {
            int iso;
            StringBuilder sb = new StringBuilder();
            for (iso = recindex; iso < soutput.length() && soutput.charAt(iso) != '$'; ++iso) {
                if (soutput.charAt(iso) == '#') continue;
                sb.append(soutput.charAt(iso));
            }
            String curoutput = sb.toString();
            RefObject<Object> tempRef_tailoutputs = new RefObject<Object>(tailoutputs);
            boolean res = this.ProcessVariablesInString(soutput, hvariables, iso, tempRef_tailoutputs);
            tailoutputs = (ArrayList)tempRef_tailoutputs.argvalue;
            if (!res) {
                resoutputs.argvalue = null;
                return false;
            }
            if (tailoutputs == null) {
                resoutputs.argvalue = null;
                return true;
            }
            resoutputs.argvalue = new ArrayList();
            for (int i2 = 0; i2 < tailoutputs.size(); ++i2) {
                String aresoutput = curoutput + (String)tailoutputs.get(i2);
                ((ArrayList)resoutputs.argvalue).add(aresoutput);
            }
            return true;
        }
        int j = 0;
        RefObject<Integer> tempRef_j = new RefObject<Integer>(j);
        String varname = Dic.getFullVariableName(soutput, recindex, tempRef_j);
        int iso = j = ((Integer)tempRef_j.argvalue).intValue();
        ArrayList<String> curoutputs = new ArrayList<String>();
        if (hvariables.containsKey(varname)) {
            curoutputs.add(hvariables.get(varname));
        } else if (varname.indexOf(36) != -1) {
            String basename = varname.substring(0, varname.indexOf(36));
            String lex = hvariables.get(basename);
            if (lex == null) {
                resoutputs.argvalue = null;
                return false;
            }
            ArrayList lexs = null;
            RefObject<Object> tempRef_lexs = new RefObject<Object>(lexs);
            Dic.normalizeLexemeSymbol(lex, this, tempRef_lexs);
            lexs = (ArrayList)tempRef_lexs.argvalue;
            if (lexs == null) {
                resoutputs.argvalue = null;
                return false;
            }
            Language lan1 = null;
            String errmessage = null;
            curoutputs = new ArrayList();
            for (String lex0 : lexs) {
                ArrayList<String> aux = new ArrayList<String>();
                aux.add(lex0);
                RefObject<Object> tempRef_lan1 = new RefObject<Object>(lan1);
                RefObject<Object> tempRef_errmessage = new RefObject<Object>(errmessage);
                String[] cresults = this.computeDerivations(varname.substring(basename.length()), aux, tempRef_lan1);
                lan1 = (Language)tempRef_lan1.argvalue;
                errmessage = (String)tempRef_errmessage.argvalue;
                for (int i = 0; i < cresults.length; ++i) {
                    curoutputs.add(cresults[i]);
                }
            }
            if (curoutputs.isEmpty()) {
                resoutputs.argvalue = null;
                return false;
            }
        } else {
            resoutputs.argvalue = null;
            return false;
        }
        RefObject<ArrayList<String>> tempRef_tailoutputs3 = new RefObject<ArrayList<String>>(tailoutputs);
        boolean res = this.ProcessVariablesInString(soutput, hvariables, iso, tempRef_tailoutputs3);
        tailoutputs = (ArrayList)tempRef_tailoutputs3.argvalue;
        if (!res) {
            resoutputs.argvalue = null;
            return false;
        }
        if (tailoutputs == null) {
            resoutputs.argvalue = null;
            return true;
        }
        resoutputs.argvalue = new ArrayList();
        for (int icur = 0; icur < curoutputs.size(); ++icur) {
            String curoutput = (String)curoutputs.get(icur);
            for (int itail = 0; itail < tailoutputs.size(); ++itail) {
                String sres = curoutput + (String)tailoutputs.get(itail);
                ((ArrayList)resoutputs.argvalue).add(sres);
            }
        }
        return true;
    }

    private final boolean ProcessConstraintsInString(String currentline, double cpos, int ipos, Mft textmft, int rightmargin, ArrayList<Object> annotations, int tunb, ArrayList<Double> positiontrace, ArrayList<String> variabletrace, String soutput, Grammar grammar, RefObject<ArrayList<String>> resoutputs, RefObject<ArrayList<HashMap<String, String>>> resvariables, int recindex, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        boolean check;
        ParameterCheck.mandatoryString("soutput", soutput);
        ParameterCheck.mandatory("resoutputs", resoutputs);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        if (recindex >= soutput.length()) {
            resoutputs.argvalue = new ArrayList();
            ((ArrayList)resoutputs.argvalue).add("");
            return true;
        }
        int iso = 0;
        ArrayList curoutputs = null;
        ArrayList tailoutputs = null;
        for (int uu = 0; uu < 1; ++uu) {
            String aresoutput;
            String curoutput;
            if (soutput.charAt(recindex) == '$') {
                RefObject<Object> tempRef_curoutputs = new RefObject<Object>(curoutputs);
                RefObject<Integer> tempRef_iso = new RefObject<Integer>(iso);
                check = this.ProcessSingleVariableInString(null, currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_curoutputs, resvariables, recindex, tempRef_iso);
                curoutputs = (ArrayList)tempRef_curoutputs.argvalue;
                iso = (Integer)tempRef_iso.argvalue;
                if (check) break;
                errmessage.argvalue = soutput.substring(recindex) + " undefined";
                resoutputs.argvalue = null;
                resvariables.argvalue = null;
                return false;
            }
            if (soutput.charAt(recindex) == '\"') {
                StringBuilder sb = new StringBuilder();
                sb.append('\"');
                for (iso = recindex + 1; iso < soutput.length() && soutput.charAt(iso) != '\"'; ++iso) {
                    sb.append(soutput.charAt(iso));
                }
                sb.append('\"');
                curoutput = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.ProcessConstraintsInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs, resvariables, iso + 1, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs.argvalue;
                if (errmessage.argvalue != null || !check) {
                    resoutputs.argvalue = null;
                    resvariables.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                for (int i2 = 0; i2 < tailoutputs.size(); ++i2) {
                    aresoutput = curoutput + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput);
                }
                return true;
            }
            if (soutput.charAt(recindex) != '<') {
                StringBuilder sb = new StringBuilder();
                for (iso = recindex; iso < soutput.length() && soutput.charAt(iso) != '<' && soutput.charAt(iso) != '\"' && soutput.charAt(iso) != '$'; ++iso) {
                    sb.append(soutput.charAt(iso));
                }
                curoutput = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs2 = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.ProcessConstraintsInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs2, resvariables, iso, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs2.argvalue;
                if (errmessage.argvalue != null || !check) {
                    resoutputs.argvalue = null;
                    resvariables.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                for (int i2 = 0; i2 < tailoutputs.size(); ++i2) {
                    aresoutput = curoutput + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput);
                }
                return true;
            }
            int j = 1;
            while (recindex + j < soutput.length() && soutput.charAt(recindex + j) != '>') {
                ++j;
            }
            if (recindex + j >= soutput.length()) {
                StringBuilder sb = new StringBuilder();
                sb.append("<");
                for (iso = recindex + 1; iso < soutput.length() && soutput.charAt(iso) != '<' && soutput.charAt(iso) != '$'; ++iso) {
                    sb.append(soutput.charAt(iso));
                }
                String curoutput2 = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs3 = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.ProcessConstraintsInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs3, resvariables, iso, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs3.argvalue;
                if (!check) {
                    resoutputs.argvalue = null;
                    resvariables.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                for (int i2 = 0; i2 < tailoutputs.size(); ++i2) {
                    String aresoutput2 = curoutput2 + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput2);
                }
                return true;
            }
            String constraint = soutput.substring(recindex, recindex + j + 1);
            if (!Dic.isALexicalConstraint(constraint)) {
                StringBuilder sb = new StringBuilder();
                sb.append("<");
                for (iso = recindex + 1; iso < soutput.length() && soutput.charAt(iso) != '<' && soutput.charAt(iso) != '$'; ++iso) {
                    sb.append(soutput.charAt(iso));
                }
                String curoutput3 = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs4 = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.ProcessConstraintsInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs4, resvariables, iso, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs4.argvalue;
                if (!check) {
                    resoutputs.argvalue = null;
                    resvariables.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                for (int i2 = 0; i2 < tailoutputs.size(); ++i2) {
                    String aresoutput3 = curoutput3 + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput3);
                }
                return true;
            }
            String left = null;
            String nop = null;
            String right = null;
            RefObject<Object> tempRef_left = new RefObject<Object>(left);
            RefObject<Object> tempRef_nop = new RefObject<Object>(nop);
            RefObject<Object> tempRef_right = new RefObject<Object>(right);
            Dic.parseLexicalConstraint(constraint, tempRef_left, tempRef_nop, tempRef_right);
            left = (String)tempRef_left.argvalue;
            nop = (String)tempRef_nop.argvalue;
            right = (String)tempRef_right.argvalue;
            boolean negation = false;
            ArrayList leftstrings = null;
            ArrayList rightstrings = null;
            RefObject<Object> tempRef_leftstrings = new RefObject<Object>(leftstrings);
            boolean leftcheck = this.ProcessVariablesInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, left, grammar, tempRef_leftstrings, resvariables, 0);
            leftstrings = (ArrayList)tempRef_leftstrings.argvalue;
            if (!leftcheck) {
                errmessage.argvalue = constraint + " undefined";
            }
            boolean rightcheck = false;
            if (leftcheck) {
                RefObject<Object> tempRef_rightstrings = new RefObject<Object>(rightstrings);
                rightcheck = this.ProcessVariablesInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, right, grammar, tempRef_rightstrings, resvariables, 0);
                rightstrings = (ArrayList)tempRef_rightstrings.argvalue;
                if (!rightcheck) {
                    errmessage.argvalue = constraint + " undefined";
                }
                if (rightcheck) {
                    RefObject<ArrayList<String>> tempRef_curoutputs2 = new RefObject<ArrayList<String>>(curoutputs);
                    check = this.SolveConstraint(left, leftstrings, rightstrings, nop, negation, grammar, tempRef_curoutputs2, resvariables, errmessage);
                    curoutputs = (ArrayList)tempRef_curoutputs2.argvalue;
                    if (!check) {
                        errmessage.argvalue = constraint + " failed";
                        resoutputs.argvalue = null;
                        resvariables.argvalue = null;
                        return false;
                    }
                } else {
                    curoutputs = new ArrayList();
                    curoutputs.add("");
                }
            } else {
                curoutputs = new ArrayList();
                curoutputs.add("");
            }
            iso = recindex + j + 1;
        }
        RefObject<Object> tempRef_tailoutputs5 = new RefObject<Object>(tailoutputs);
        check = this.ProcessConstraintsInString(currentline, cpos, ipos, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_tailoutputs5, resvariables, iso, errmessage);
        tailoutputs = (ArrayList)tempRef_tailoutputs5.argvalue;
        if (!check) {
            resoutputs.argvalue = null;
            resvariables.argvalue = null;
            return false;
        }
        resoutputs.argvalue = new ArrayList();
        for (int i2 = 0; i2 < tailoutputs.size(); ++i2) {
            for (int icur = 0; icur < curoutputs.size(); ++icur) {
                String aresoutput = (String)curoutputs.get(icur) + (String)tailoutputs.get(i2);
                ((ArrayList)resoutputs.argvalue).add(aresoutput);
            }
        }
        return true;
    }

    public final boolean ProcessConstraintsInStringForTransformed(String soutput, HashMap<String, String> hvars, int recindex, Grammar grammar, RefObject<ArrayList<String>> resoutputs, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        String aresoutput;
        boolean check;
        ParameterCheck.mandatory("resoutputs", resoutputs);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        if (recindex >= soutput.length()) {
            resoutputs.argvalue = new ArrayList();
            ((ArrayList)resoutputs.argvalue).add("");
            return true;
        }
        int iso = 0;
        ArrayList curoutputs = null;
        ArrayList tailoutputs = null;
        for (int uu = 0; uu < 1; ++uu) {
            if (soutput.charAt(recindex) == '$') {
                RefObject<Integer> tempRef_iso = new RefObject<Integer>(iso);
                RefObject<Object> tempRef_curoutputs = new RefObject<Object>(curoutputs);
                check = this.ProcessSingleVariableInString(hvars, null, 0.0, 0, null, 0, null, 0, null, null, soutput, null, tempRef_curoutputs, null, recindex, tempRef_iso);
                iso = (Integer)tempRef_iso.argvalue;
                curoutputs = (ArrayList)tempRef_curoutputs.argvalue;
                if (check) break;
                errmessage.argvalue = soutput + " undefined";
                aresoutput = "*" + soutput + " undefined*";
                resoutputs.argvalue = new ArrayList();
                ((ArrayList)resoutputs.argvalue).add(aresoutput);
                return true;
            }
            if (soutput.charAt(recindex) != '<') {
                StringBuilder sb = new StringBuilder();
                for (iso = recindex; iso < soutput.length() && soutput.charAt(iso) != '<' && soutput.charAt(iso) != '$'; ++iso) {
                    sb.append(soutput.charAt(iso));
                }
                String curoutput = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.ProcessConstraintsInStringForTransformed(soutput, hvars, iso, grammar, tempRef_tailoutputs, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs.argvalue;
                if (errmessage.argvalue != null || !check) {
                    resoutputs.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                for (int i2 = 0; i2 < tailoutputs.size(); ++i2) {
                    String aresoutput2 = curoutput + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput2);
                }
                return true;
            }
            int j = 1;
            while (recindex + j < soutput.length() && soutput.charAt(recindex + j) != '>') {
                ++j;
            }
            if (recindex + j >= soutput.length()) {
                StringBuilder sb = new StringBuilder();
                sb.append("<");
                for (iso = recindex + 1; iso < soutput.length() && soutput.charAt(iso) != '<' && soutput.charAt(iso) != '$'; ++iso) {
                    sb.append(soutput.charAt(iso));
                }
                String curoutput = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs2 = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.ProcessConstraintsInStringForTransformed(soutput, hvars, iso, grammar, tempRef_tailoutputs2, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs2.argvalue;
                if (!check) {
                    resoutputs.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                for (int i2 = 0; i2 < tailoutputs.size(); ++i2) {
                    String aresoutput3 = curoutput + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput3);
                }
                return true;
            }
            String constraint = soutput.substring(recindex, recindex + j + 1);
            if (!Dic.isALexicalConstraint(constraint)) {
                StringBuilder sb = new StringBuilder();
                sb.append("<");
                for (iso = recindex + 1; iso < soutput.length() && soutput.charAt(iso) != '<' && soutput.charAt(iso) != '$'; ++iso) {
                    sb.append(soutput.charAt(iso));
                }
                String curoutput = sb.toString();
                RefObject<ArrayList<String>> tempRef_tailoutputs3 = new RefObject<ArrayList<String>>(tailoutputs);
                check = this.ProcessConstraintsInStringForTransformed(soutput, hvars, iso, grammar, tempRef_tailoutputs3, errmessage);
                tailoutputs = (ArrayList)tempRef_tailoutputs3.argvalue;
                if (!check) {
                    resoutputs.argvalue = null;
                    return false;
                }
                resoutputs.argvalue = new ArrayList();
                for (int i2 = 0; i2 < tailoutputs.size(); ++i2) {
                    String aresoutput4 = curoutput + (String)tailoutputs.get(i2);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput4);
                }
                return true;
            }
            curoutputs = new ArrayList();
            curoutputs.add("");
            String left = null;
            String nop = null;
            String right = null;
            RefObject<Object> tempRef_left = new RefObject<Object>(left);
            RefObject<Object> tempRef_nop = new RefObject<Object>(nop);
            RefObject<Object> tempRef_right = new RefObject<Object>(right);
            Dic.parseLexicalConstraint(constraint, tempRef_left, tempRef_nop, tempRef_right);
            left = (String)tempRef_left.argvalue;
            nop = (String)tempRef_nop.argvalue;
            right = (String)tempRef_right.argvalue;
            boolean negation = false;
            ArrayList leftstrings = null;
            ArrayList rightstrings = null;
            RefObject<Object> tempRef_leftstrings = new RefObject<Object>(leftstrings);
            boolean leftcheck = this.ProcessVariablesInString(left, hvars, 0, tempRef_leftstrings);
            leftstrings = (ArrayList)tempRef_leftstrings.argvalue;
            if (!leftcheck) {
                errmessage.argvalue = constraint + " undefined";
            }
            boolean rightcheck = false;
            if (leftcheck) {
                RefObject<Object> tempRef_rightstrings = new RefObject<Object>(rightstrings);
                rightcheck = this.ProcessVariablesInString(right, hvars, 0, tempRef_rightstrings);
                rightstrings = (ArrayList)tempRef_rightstrings.argvalue;
                if (!rightcheck) {
                    errmessage.argvalue = constraint + " undefined";
                }
                if (rightcheck) {
                    ArrayList listofhvars = new ArrayList();
                    listofhvars.add(hvars);
                    RefObject<ArrayList<HashMap<String, String>>> tempRef_listofhvars = new RefObject<ArrayList<HashMap<String, String>>>(listofhvars);
                    check = this.SolveConstraintForTransformed(left, leftstrings, rightstrings, nop, negation, grammar, tempRef_listofhvars, errmessage);
                    listofhvars = (ArrayList)tempRef_listofhvars.argvalue;
                    if (!check) {
                        errmessage.argvalue = constraint + " failed";
                        resoutputs.argvalue = null;
                        return false;
                    }
                }
            }
            iso = recindex + j + 1;
        }
        RefObject<Object> tempRef_tailoutputs4 = new RefObject<Object>(tailoutputs);
        check = this.ProcessConstraintsInStringForTransformed(soutput, hvars, iso, grammar, tempRef_tailoutputs4, errmessage);
        tailoutputs = (ArrayList)tempRef_tailoutputs4.argvalue;
        if (!check) {
            resoutputs.argvalue = null;
            return false;
        }
        resoutputs.argvalue = new ArrayList();
        for (int i2 = 0; i2 < tailoutputs.size(); ++i2) {
            for (int icur = 0; icur < curoutputs.size(); ++icur) {
                aresoutput = (String)curoutputs.get(icur) + (String)tailoutputs.get(i2);
                ((ArrayList)resoutputs.argvalue).add(aresoutput);
            }
        }
        return true;
    }

    private boolean sameHashMaps(HashMap<String, String> h1, HashMap<String, String> h2) {
        if (h1 == null) {
            return h2 == null;
        }
        if (h2 == null) {
            return false;
        }
        if (h1.size() != h2.size()) {
            return false;
        }
        for (String key : h1.keySet()) {
            String val2;
            if (!h2.containsKey(key)) {
                return false;
            }
            String val1 = h1.get(key);
            if (val1.equals(val2 = h2.get(key))) continue;
            return false;
        }
        return true;
    }

    private void removeAllThisVariables(RefObject<ArrayList<HashMap<String, String>>> resvariables) {
        ParameterCheck.mandatory("resvariables", resvariables);
        for (int i = 0; i < ((ArrayList)resvariables.argvalue).size(); ++i) {
            HashMap hvar = (HashMap)((ArrayList)resvariables.argvalue).get(i);
            ArrayList<String> allkeystoremove = new ArrayList<String>();
            for (String key : hvar.keySet()) {
                if (key.length() < new String("THIS").length() || !key.substring(0, new String("THIS").length()).equals("THIS")) continue;
                allkeystoremove.add(key);
            }
            for (String key : allkeystoremove) {
                hvar.remove(key);
            }
        }
    }

    public final boolean newProcessConstraints(String currentline, Mft textmft, ArrayList<Object> annotations, int tunb, Grammar grammar, ArrayList<Double> positiontrace, int rightmargin, ArrayList<String> variabletrace, double cpos, ArrayList<String> output, RefObject<ArrayList<ArrayList<String>>> resoutputs, RefObject<ArrayList<HashMap<String, String>>> resvariables, int recindex, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatory("output", output);
        ParameterCheck.mandatory("resoutputs", resoutputs);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        if (recindex >= output.size()) {
            resoutputs.argvalue = new ArrayList();
            ((ArrayList)resoutputs.argvalue).add(new ArrayList());
            return true;
        }
        ArrayList tailoutputs = null;
        RefObject<Object> tempRef_tailoutputs = new RefObject<Object>(tailoutputs);
        boolean check = this.newProcessConstraints(currentline, textmft, annotations, tunb, grammar, positiontrace, rightmargin, variabletrace, cpos, output, tempRef_tailoutputs, resvariables, recindex + 1, errmessage);
        tailoutputs = (ArrayList)tempRef_tailoutputs.argvalue;
        if (!check) {
            resoutputs.argvalue = null;
            return false;
        }
        ArrayList curoutputs2 = null;
        String soutput = output.get(recindex);
        if (soutput == null) {
            curoutputs2 = new ArrayList();
            curoutputs2.add(null);
        } else {
            RefObject<ArrayList<String>> tempRef_curoutputs2 = new RefObject<ArrayList<String>>(curoutputs2);
            check = this.ProcessConstraintsInString(currentline, cpos, recindex, textmft, rightmargin, annotations, tunb, positiontrace, variabletrace, soutput, grammar, tempRef_curoutputs2, resvariables, 0, errmessage);
            curoutputs2 = (ArrayList)tempRef_curoutputs2.argvalue;
            if (!check) {
                resoutputs.argvalue = null;
                resvariables.argvalue = null;
                return false;
            }
            this.removeAllThisVariables(resvariables);
            if (curoutputs2 != null && curoutputs2.size() >= 2) {
                for (int i = 0; i < curoutputs2.size(); ++i) {
                    int j = i + 1;
                    while (j < curoutputs2.size()) {
                        if (curoutputs2.get(i) == curoutputs2.get(j) && this.sameHashMaps((HashMap)((ArrayList)resvariables.argvalue).get(i), (HashMap)((ArrayList)resvariables.argvalue).get(j))) {
                            curoutputs2.remove(j);
                            ((ArrayList)resvariables.argvalue).remove(j);
                            continue;
                        }
                        ++j;
                    }
                }
            }
        }
        resoutputs.argvalue = new ArrayList();
        if (curoutputs2 != null) {
            for (int itail = 0; itail < tailoutputs.size(); ++itail) {
                ArrayList atailoutput = (ArrayList)tailoutputs.get(itail);
                for (int icur = 0; icur < curoutputs2.size(); ++icur) {
                    String curoutput = (String)curoutputs2.get(icur);
                    ArrayList<String> aresoutput = new ArrayList<String>(atailoutput);
                    aresoutput.add(0, curoutput);
                    ((ArrayList)resoutputs.argvalue).add(aresoutput);
                }
            }
        }
        return true;
    }

    public final void moveBegAddressOufOfSpaces(String buffer, boolean expectXMLtags, RefObject<Double> absolutebegaddress) {
        ParameterCheck.mandatoryString("buffer", buffer);
        ParameterCheck.mandatory("absolutebegaddress", absolutebegaddress);
        boolean aproblem = true;
        while (aproblem) {
            Double d;
            Double d2;
            RefObject<Double> refObject;
            aproblem = false;
            if (Character.isWhitespace(buffer.charAt((int)((Double)absolutebegaddress.argvalue).doubleValue()))) {
                aproblem = true;
                refObject = absolutebegaddress;
                d2 = (Double)refObject.argvalue;
                refObject.argvalue = (Double)refObject.argvalue + 1.0;
                d = refObject.argvalue;
                continue;
            }
            if (!expectXMLtags || buffer.charAt((int)((Double)absolutebegaddress.argvalue).doubleValue()) != '<') continue;
            aproblem = true;
            refObject = absolutebegaddress;
            d2 = (Double)refObject.argvalue;
            refObject.argvalue = (Double)refObject.argvalue + 1.0;
            d = refObject.argvalue;
            while (buffer.charAt((int)((Double)absolutebegaddress.argvalue).doubleValue()) != '>') {
                refObject = absolutebegaddress;
                d2 = (Double)refObject.argvalue;
                refObject.argvalue = (Double)refObject.argvalue + 1.0;
                d = refObject.argvalue;
            }
            refObject = absolutebegaddress;
            d2 = (Double)refObject.argvalue;
            refObject.argvalue = (Double)refObject.argvalue + 1.0;
            d = refObject.argvalue;
        }
    }

    private ArrayList<String> mergeOutputWithLexemes(ArrayList<String> output, ArrayList<String> lexemes) {
        ParameterCheck.mandatory("output", output);
        ParameterCheck.mandatory("lexemes", lexemes);
        ArrayList<String> merged = new ArrayList<String>();
        for (int i = 0; i < output.size(); ++i) {
            String op = output.get(i);
            String lx = lexemes.get(i);
            if (op != null) {
                merged.add(op + "#");
            }
            if (lx == null) continue;
            if (lx.length() >= 1 && lx.charAt(0) == ':') {
                merged.add(lx + "#");
                continue;
            }
            if (lx.length() > 2 && lx.charAt(0) == '$' && lx.charAt(1) == '(' || lx.charAt(1) == ')') {
                merged.add(lx + "#");
                continue;
            }
            merged.add("<" + Dic.getRidOfSpecialFeatures(lx) + ">" + "#");
        }
        return merged;
    }

    public final TheSolutions syntacticParsing(Ntext text, ArrayList<Object> annotations, Grammar grammar, char cm, int limitation, boolean keepLexemesInSolution, boolean enforcecompletexrefs, RefObject<Boolean> thereisunamb, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        MatchType typeofmatch;
        ParameterCheck.mandatory("text", text);
        ParameterCheck.mandatory("grammar", grammar);
        ParameterCheck.mandatory("thereisunamb", thereisunamb);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        ArrayList<String> recursiveCalls = new ArrayList<String>();
        TheSolutions sols = null;
        thereisunamb.argvalue = false;
        Gram grm = grammar.grams.get("Main");
        if (grm == null) {
            errmessage.argvalue = "Grammar has no main graph/rule";
            Dic.writeLog((String)errmessage.argvalue);
            return null;
        }
        if (cm == 'A') {
            typeofmatch = MatchType.ALL;
        } else if (cm == 'S') {
            typeofmatch = MatchType.SHORTEST;
        } else if (cm == 'L') {
            typeofmatch = MatchType.LONGEST;
        } else if (cm == 'X') {
            typeofmatch = MatchType.ALL;
        } else {
            System.out.println("type of match unknown");
            return null;
        }
        boolean limitfinish = false;
        int nbofmatches = 0;
        int progressPercentage = 0;
        for (int itu = 1; itu <= text.mft.tuAddresses.length - 1 && !limitfinish; ++itu) {
            int tuaddress = text.mft.tuAddresses[itu];
            this.CurrentLine = text.buffer.substring(tuaddress, tuaddress + text.mft.tuLengths[itu]);
            int inewsols = -1;
            if (sols != null) {
                inewsols = sols.list.size();
            }
            int ichar = 0;
            block1: while (ichar < this.CurrentLine.length() && !limitfinish) {
                if (Character.isWhitespace(this.CurrentLine.charAt(ichar))) {
                    ++ichar;
                    continue;
                }
                double cpos = ichar;
                if (!this.Lan.asianTokenizer && Language.isLetter(this.CurrentLine.charAt(ichar))) {
                    ++ichar;
                    while (ichar < this.CurrentLine.length() && Language.isLetter(this.CurrentLine.charAt(ichar))) {
                        ++ichar;
                    }
                } else {
                    ++ichar;
                }
                ArrayList sollengths = null;
                ArrayList solinputs = null;
                ArrayList soloutputs = null;
                Object solnodes = null;
                ArrayList solvariables = null;
                while (true) {
                    if (this.BackgroundWorking) {
                        if (this.backgroundWorker.isCancellationPending()) {
                            errmessage.argvalue = "Cancelled";
                            Dic.writeLog((String)errmessage.argvalue);
                            return null;
                        }
                        int nprogress = (int)((float)itu * 100.0f / (float)text.nbOfTextUnits);
                        if (nprogress != progressPercentage) {
                            progressPercentage = nprogress;
                            if (this.backgroundWorker.isBusy()) {
                                this.backgroundWorker.reportProgress(nprogress);
                            }
                        }
                    }
                    RefObject<Object> tempRef_sollengths = new RefObject<Object>(sollengths);
                    RefObject<Object> tempRef_solinputs = new RefObject<Object>(solinputs);
                    RefObject<Object> tempRef_solvariables = new RefObject<Object>(solvariables);
                    RefObject<Object> tempRef_soloutputs = new RefObject<Object>(soloutputs);
                    RefObject<Object> tempRef_solnodes = new RefObject<Object>(solnodes);
                    int da = grammar.syntaxMatch(grammar.fullName, -1, this.CurrentLine, cpos, itu, text.mft, annotations, grm, tempRef_sollengths, tempRef_solinputs, tempRef_solvariables, tempRef_soloutputs, tempRef_solnodes, true, recursiveCalls);
                    sollengths = (ArrayList)tempRef_sollengths.argvalue;
                    solinputs = (ArrayList)tempRef_solinputs.argvalue;
                    solvariables = (ArrayList)tempRef_solvariables.argvalue;
                    soloutputs = (ArrayList)tempRef_soloutputs.argvalue;
                    if (da > 0) {
                        ArrayList res_solinputs = new ArrayList();
                        ArrayList res_soloutputs = new ArrayList();
                        ArrayList res_sollengths = new ArrayList();
                        ArrayList res_solvariables = new ArrayList();
                        for (int isol = 0; isol < sollengths.size(); ++isol) {
                            ArrayList soloutput = (ArrayList)soloutputs.get(isol);
                            this.deleteONCE(soloutput);
                            int rightmargin = (int)(cpos + (Double)sollengths.get(isol));
                            ArrayList tmpoutputs = null;
                            ArrayList resvariables = new ArrayList();
                            resvariables.add(new HashMap());
                            RefObject<Object> tempRef_tmpoutputs = new RefObject<Object>(tmpoutputs);
                            RefObject<ArrayList<HashMap<String, String>>> tempRef_resvariables = new RefObject<ArrayList<HashMap<String, String>>>(resvariables);
                            boolean check = this.newProcessConstraints(this.CurrentLine, text.mft, annotations, itu, grammar, (ArrayList)solinputs.get(isol), rightmargin, (ArrayList)solvariables.get(isol), cpos, soloutput, tempRef_tmpoutputs, tempRef_resvariables, 0, errmessage);
                            tmpoutputs = (ArrayList)tempRef_tmpoutputs.argvalue;
                            resvariables = (ArrayList)tempRef_resvariables.argvalue;
                            if (!check) continue;
                            for (int i2 = 0; i2 < tmpoutputs.size(); ++i2) {
                                soloutput = (ArrayList)tmpoutputs.get(i2);
                                this.deleteAllLUsFromOutput(soloutput);
                                res_solinputs.add(solinputs.get(isol));
                                res_soloutputs.add(tmpoutputs.get(i2));
                                res_sollengths.add(sollengths.get(isol));
                                res_solvariables.add(solvariables.get(isol));
                            }
                        }
                        solinputs = new ArrayList(res_solinputs);
                        soloutputs = new ArrayList(res_soloutputs);
                        sollengths = new ArrayList(res_sollengths);
                        solvariables = new ArrayList(res_solvariables);
                        da = sollengths.size();
                    }
                    boolean needminimlength = false;
                    double smallerlength = 0.0;
                    if (da > 0) {
                        RefObject<Boolean> tempRef_needminimlength = new RefObject<Boolean>(needminimlength);
                        RefObject<Double> tempRef_smallerlength = new RefObject<Double>(smallerlength);
                        da = this.filterExclude(sollengths, solinputs, solvariables, soloutputs, tempRef_needminimlength, tempRef_smallerlength);
                        needminimlength = (Boolean)tempRef_needminimlength.argvalue;
                        smallerlength = (Double)tempRef_smallerlength.argvalue;
                    }
                    if (da > 0) {
                        RefObject<Double> tempRef_smallerlength2 = new RefObject<Double>(smallerlength);
                        da = this.filterUnamb(sollengths, solinputs, solvariables, soloutputs, thereisunamb, tempRef_smallerlength2);
                        smallerlength = (Double)tempRef_smallerlength2.argvalue;
                        if (((Boolean)thereisunamb.argvalue).booleanValue()) {
                            needminimlength = true;
                        }
                    }
                    if (da > 0) {
                        if (typeofmatch == MatchType.LONGEST) {
                            if (da > 1) {
                                da = this.keepLongest(sollengths, solinputs, solvariables, soloutputs);
                            }
                            needminimlength = true;
                            smallerlength = (Double)sollengths.get(0);
                        } else if (typeofmatch == MatchType.SHORTEST) {
                            if (da > 1) {
                                da = this.keepShortest(sollengths, solinputs, solvariables, soloutputs);
                            }
                            needminimlength = true;
                            smallerlength = (Double)sollengths.get(0);
                        }
                        for (int isol = 0; !limitfinish && isol < sollengths.size(); ++isol) {
                            if ((Double)sollengths.get(isol) == 0.0) {
                                errmessage.argvalue = "Grammar " + new File(grammar.fullName).getName() + " recognizes the empty string.";
                                Dic.writeLog((String)errmessage.argvalue);
                                return null;
                            }
                            if (needminimlength) {
                                smallerlength = (Double)sollengths.get(isol);
                            }
                            if (sols == null) {
                                sols = new TheSolutions();
                            }
                            ArrayList output2 = (ArrayList)soloutputs.get(isol);
                            if (keepLexemesInSolution) {
                                ArrayList<String> o3 = this.mergeOutputWithLexemes(output2, (ArrayList)solvariables.get(isol));
                                sols.addASolution(itu, cpos, (Double)sollengths.get(isol), (ArrayList)solinputs.get(isol), o3);
                                if (limitation == -1 || ++nbofmatches <= limitation) continue;
                                limitfinish = true;
                                break;
                            }
                            sols.addASolution(itu, cpos, (Double)sollengths.get(isol), (ArrayList)solinputs.get(isol), output2);
                            if (limitation == -1 || nbofmatches <= limitation) continue;
                            limitfinish = true;
                            break;
                        }
                    }
                    if (needminimlength) {
                        if (da > 0 && ((Boolean)thereisunamb.argvalue).booleanValue()) {
                            ArrayList output = (ArrayList)soloutputs.get(0);
                            int minlen = output.size();
                            int iminlen = 0;
                            for (int isol = 1; isol < soloutputs.size(); ++isol) {
                                output = (ArrayList)soloutputs.get(isol);
                                if (output.size() >= minlen) continue;
                                minlen = output.size();
                                iminlen = isol;
                            }
                            if ((cpos += ((Double)sollengths.get(iminlen)).doubleValue()) < (double)ichar) continue;
                            if (!(cpos > (double)ichar)) continue block1;
                            ichar = (int)cpos;
                            continue block1;
                        }
                        if ((cpos += smallerlength) < (double)ichar) continue;
                        if (!(cpos > (double)ichar)) continue block1;
                        ichar = (int)cpos;
                        continue block1;
                    }
                    if (!text.mft.thereAreLexs(itu, cpos + 0.01)) continue block1;
                    cpos += 0.01;
                }
            }
        }
        errmessage.argvalue = null;
        return sols;
    }

    public boolean processConstraints(String current, Mft textmft, int tunb, ArrayList<Object> annotations, Grammar grammar, ArrayList<Double> position, int rightmargin, ArrayList<String> variable, double cpos, ArrayList<String> output, RefObject<String> errMessage) throws IOException, ClassNotFoundException {
        errMessage.argvalue = "";
        for (int ipos = 0; ipos < output.size(); ++ipos) {
            String so = output.get(ipos);
            if (so == null || so.equals("")) continue;
            boolean remove = false;
            int iso = 0;
            while (iso < so.length()) {
                String so2;
                if (so.charAt(iso) != '<') {
                    ++iso;
                    continue;
                }
                int len = -1;
                len = 1;
                while (iso + len < so.length() && so.charAt(iso + len) != '>') {
                    ++len;
                }
                if (iso + len < so.length() && Dic.isALexicalConstraint(so2 = so.substring(iso, iso + len + 1))) {
                    RefObject<ArrayList<String>> constraintresults = new RefObject<ArrayList<String>>(new ArrayList());
                    if (!this.processConstraint(current, textmft, tunb, annotations, grammar, position, rightmargin, variable, cpos, ipos, so2, constraintresults, errMessage)) {
                        return false;
                    }
                    if (constraintresults != null && ((ArrayList)constraintresults.argvalue).size() > 0) {
                        output.add(ipos, "<LU=" + (String)((ArrayList)constraintresults.argvalue).get(0) + ">");
                    } else {
                        remove = true;
                    }
                }
                iso += len + 1;
            }
            if (!remove) continue;
            output.add(ipos, "");
        }
        return true;
    }

    public static ArrayList<Double> rel2Abs(ArrayList<Double> reladdresses, long absbegaddress) {
        ParameterCheck.mandatory("reladdresses", reladdresses);
        ArrayList<Double> res = new ArrayList<Double>();
        for (int i = 0; i < reladdresses.size(); ++i) {
            long hundaddress = (long)(100.0 * reladdresses.get(i)) + 100L * absbegaddress;
            double absaddress = (double)hundaddress / 100.0;
            res.add(absaddress);
        }
        return res;
    }

    public final boolean applyAllGrammars(Ntext mytext, ArrayList<Object> annotations, int startingpoint, RefObject<String> errmessage) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatory("mytext", mytext);
        ParameterCheck.mandatory("errmessage", errmessage);
        errmessage.argvalue = null;
        if (this.synGrms == null || this.synGrms.isEmpty()) {
            errmessage.argvalue = "No grammar to apply";
            Dic.writeLog((String)errmessage.argvalue);
            return false;
        }
        for (int iprio = startingpoint; iprio < 100 && (startingpoint != 0 || iprio <= 0); ++iprio) {
            if (this.BackgroundWorking) {
                if (this.backgroundWorker.isCancellationPending()) {
                    errmessage.argvalue = "Cancelled";
                    Dic.writeLog((String)errmessage.argvalue);
                    return false;
                }
                if (this.backgroundWorker.isBusy()) {
                    this.backgroundWorker.reportProgress(0);
                }
            }
            for (int idic = 0; idic < this.synGrms.size(); idic += 3) {
                Grammar synGrm = (Grammar)this.synGrms.get(idic);
                if ((Integer)this.synGrms.get(idic + 1) != iprio) continue;
                char parsingmode = ((Character)this.synGrms.get(idic + 2)).charValue();
                boolean thereisunamb = false;
                RefObject<Boolean> tempRef_thereisunamb = new RefObject<Boolean>(thereisunamb);
                TheSolutions thesolutions = this.syntacticParsing(mytext, annotations, synGrm, parsingmode, -1, false, true, tempRef_thereisunamb, errmessage);
                thereisunamb = (Boolean)tempRef_thereisunamb.argvalue;
                if (thesolutions == null && errmessage.argvalue != null) {
                    return false;
                }
                if (thesolutions == null || thesolutions.list.isEmpty()) continue;
                for (int isol = 0; isol < thesolutions.list.size(); ++isol) {
                    double item_absoluteendaddress;
                    String item_soutput;
                    double item_absolutebegaddress;
                    int ia;
                    ArrayList<String> output;
                    ArrayList<Double> reladdresses;
                    ArrayList<Double> absaddresses;
                    long hund_endaddress;
                    double absoluteendaddress;
                    long hund_begaddress;
                    double absolutebegaddress;
                    int tunb = thesolutions.getTuNb(isol);
                    ArrayList<Object> seqofannotations = this.mergeIntoAnnotations(mytext.buffer, tunb, absolutebegaddress = (double)(hund_begaddress = (long)(100.0 * thesolutions.getBegAddress(isol)) + (long)(100 * mytext.mft.tuAddresses[tunb])) / 100.0, absoluteendaddress = (double)(hund_endaddress = (long)((absolutebegaddress + 0.005) * 100.0) + (long)(thesolutions.getLength(isol) * 100.0)) / 100.0, absaddresses = Engine.rel2Abs(reladdresses = thesolutions.getInput(isol), mytext.mft.tuAddresses[tunb]), output = thesolutions.getOutput(isol), false);
                    if (seqofannotations == null) continue;
                    for (ia = 4; ia < seqofannotations.size(); ia += 3) {
                        item_absolutebegaddress = (Double)seqofannotations.get(ia);
                        RefObject<Double> tempRef_item_absolutebegaddress = new RefObject<Double>(item_absolutebegaddress);
                        item_absolutebegaddress = (Double)tempRef_item_absolutebegaddress.argvalue;
                        item_soutput = (String)seqofannotations.get(ia + 1);
                        item_absoluteendaddress = (Double)seqofannotations.get(ia + 2);
                        if (item_absolutebegaddress != item_absoluteendaddress) continue;
                        int nbofsolutions = 1;
                        for (int c_isol = 0; c_isol < thesolutions.list.size(); ++c_isol) {
                            double c_begaddress;
                            int c_tunb = thesolutions.getTuNb(c_isol);
                            if (c_tunb < tunb) continue;
                            if (c_tunb > tunb) break;
                            if (c_isol == isol || (c_begaddress = (double)(hund_begaddress = (long)(100.0 * thesolutions.getBegAddress(c_isol)) + (long)(100 * mytext.mft.tuAddresses[c_tunb])) / 100.0) < absolutebegaddress) continue;
                            if (c_begaddress > absolutebegaddress) break;
                            hund_endaddress = (long)(100.0 * c_begaddress) + (long)(100.0 * thesolutions.getLength(c_isol));
                            double c_endaddress = (double)hund_endaddress / 100.0;
                            if (c_endaddress != absoluteendaddress) continue;
                            ++nbofsolutions;
                            break;
                        }
                        if (nbofsolutions != true) continue;
                        long a = (long)((item_absolutebegaddress + 0.005) * 100.0);
                        long r = a - (long)(100 * mytext.mft.tuAddresses[tunb]);
                        double relbegaddress = (double)r / 100.0;
                        boolean anxrefwasremoved = false;
                        RefObject<Boolean> tempRef_anxrefwasremoved = new RefObject<Boolean>(anxrefwasremoved);
                        mytext.mft.filterTransitions(annotations, tunb, relbegaddress, item_soutput, tempRef_anxrefwasremoved);
                        anxrefwasremoved = (Boolean)tempRef_anxrefwasremoved.argvalue;
                    }
                    for (ia = 4; ia < seqofannotations.size(); ia += 3) {
                        item_absolutebegaddress = (Double)seqofannotations.get(ia);
                        RefObject<Double> tempRef_item_absolutebegaddress2 = new RefObject<Double>(item_absolutebegaddress);
                        item_absolutebegaddress = (Double)tempRef_item_absolutebegaddress2.argvalue;
                        item_soutput = (String)seqofannotations.get(ia + 1);
                        item_absoluteendaddress = (Double)seqofannotations.get(ia + 2);
                        if (!(item_absolutebegaddress < item_absoluteendaddress)) continue;
                        long hund_relbegaddress = (long)(100.0 * item_absolutebegaddress) - 100L * (long)mytext.mft.tuAddresses[tunb];
                        double relbegaddress = (double)hund_relbegaddress / 100.0;
                        long hund_relendaddress = (long)(100.0 * item_absoluteendaddress) - 100L * (long)mytext.mft.tuAddresses[tunb];
                        double relendaddress = (double)hund_relendaddress / 100.0;
                        String sinput = Dic.cleanupEntry(mytext.buffer.substring((int)item_absolutebegaddress, (int)item_absoluteendaddress));
                        if ((item_soutput = Dic.cleanUpDoubleQuotes(item_soutput)).length() > 0 && item_soutput.charAt(0) == '<') {
                            StringBuilder sb = new StringBuilder();
                            int reclevel = 1;
                            for (int i = 1; i < item_soutput.length(); ++i) {
                                if (reclevel == 1 && item_soutput.charAt(i) == '>') {
                                    --reclevel;
                                    continue;
                                }
                                if (item_soutput.charAt(i) == '<') {
                                    ++reclevel;
                                }
                                if (item_soutput.charAt(i) == '>') {
                                    --reclevel;
                                }
                                sb.append(item_soutput.charAt(i));
                            }
                            item_soutput = sb.toString();
                        }
                        boolean resetannotations = parsingmode == 'X' && thereisunamb;
                        Object entry = null;
                        RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
                        Object lemma = null;
                        RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
                        Object info = null;
                        RefObject<Object> tempRef_info = new RefObject<Object>(info);
                        if (Dic.parseDELAF(item_soutput, tempRef_entry, tempRef_lemma, tempRef_info, null, null, null)) {
                            if (sinput.equals("")) {
                                this.addSyntaxToText(annotations, null, mytext.hPhrases, item_soutput, mytext.mft, tunb, relbegaddress, relendaddress, resetannotations);
                                continue;
                            }
                            this.addSyntaxToText(annotations, null, mytext.hPhrases, sinput + "," + item_soutput, mytext.mft, tunb, relbegaddress, relendaddress, resetannotations);
                            continue;
                        }
                        String lexeme = sinput + ",SYNTAX," + item_soutput;
                        if (Dic.parseDELAF(lexeme, tempRef_entry, tempRef_lemma, tempRef_info, null, null, null)) {
                            this.addSyntaxToText(annotations, null, mytext.hPhrases, lexeme, mytext.mft, tunb, relbegaddress, relendaddress, resetannotations);
                            continue;
                        }
                        this.addSyntaxToText(annotations, null, mytext.hPhrases, sinput + ",INVALIDLEXEME", mytext.mft, tunb, relbegaddress, relendaddress, resetannotations);
                    }
                }
            }
        }
        return true;
    }

    private String combineAllFeatures(String[] alloriginalfeatures) {
        if (alloriginalfeatures == null || alloriginalfeatures.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String feat : alloriginalfeatures) {
            sb.append("+" + feat);
        }
        return sb.toString();
    }

    private ArrayList<String> inflectAndDerive(String entry, String lemma, String category, String[] alloriginalfeatures) {
        String[] myfeaturesdrv;
        Gram grm;
        ParameterCheck.mandatoryString("category", category);
        ArrayList lexemes = null;
        String[] lexfeatures = Dic.getRidOfInflectionalFeatures(alloriginalfeatures, this.prop_inf);
        String myfeatureflx = Dic.lookFor("FLX", null, lexfeatures);
        String expname = null;
        if (myfeatureflx != null && (grm = this.paradigms.get(expname = myfeatureflx.substring(new String("FLX=").length()))) != null) {
            String[] forms = null;
            String[] outputs = null;
            RefObject<Object> tempRef_forms = new RefObject<Object>(forms);
            RefObject<Object> tempRef_outputs = new RefObject<Object>(outputs);
            grm.inflect(this.Lan, lemma, tempRef_forms, tempRef_outputs, this.paradigms);
            forms = (String[])tempRef_forms.argvalue;
            outputs = (String[])tempRef_outputs.argvalue;
            for (int ires = 0; ires < forms.length; ++ires) {
                String lex0 = forms[ires] + "," + lemma + "," + category + outputs[ires] + this.combineAllFeatures(lexfeatures);
                RefObject<Object> tempRef_lexemes = new RefObject<Object>(lexemes);
                Dic.normalizeLexicalEntry(lex0, this, tempRef_lexemes);
                lexemes = (ArrayList)tempRef_lexemes.argvalue;
            }
        }
        if ((myfeaturesdrv = Dic.lookForAll("DRV", null, lexfeatures)) == null) {
            return lexemes;
        }
        String[] nonflxfeatures = Dic.getRidOfInflectionalFeatures(lexfeatures, this.prop_inf);
        if (nonflxfeatures == null) {
            return lexemes;
        }
        for (String myfeaturedrv : myfeaturesdrv) {
            String flxname;
            String drvname;
            String expname2 = myfeaturedrv.substring(new String("DRV=").length());
            int index = expname2.indexOf(58);
            if (index == -1) {
                drvname = expname2;
                flxname = expname;
            } else {
                drvname = expname2.substring(0, index);
                flxname = expname2.substring(index + 1);
            }
            Gram grm2 = this.paradigms.get(drvname);
            if (grm2 == null) continue;
            String[] forms = null;
            String[] outputs = null;
            RefObject<Object> tempRef_forms = new RefObject<Object>(forms);
            RefObject<Object> tempRef_outputs = new RefObject<Object>(outputs);
            grm2.inflect(this.Lan, lemma, tempRef_forms, tempRef_outputs, this.paradigms);
            forms = (String[])tempRef_forms.argvalue;
            outputs = (String[])tempRef_outputs.argvalue;
            StringBuilder initialinfo = new StringBuilder();
            for (String feat : nonflxfeatures) {
                if (feat.equals("NW")) continue;
                initialinfo.append("+" + feat);
            }
            for (int ires = 0; ires < forms.length; ++ires) {
                if (flxname == null) {
                    String res = forms[ires] + "," + lemma + ",";
                    res = outputs[ires].length() > 1 && outputs[ires].charAt(0) == '+' ? res + outputs[ires].substring(1) : res + outputs[ires];
                    RefObject<ArrayList<String>> tempRef_lexemes2 = new RefObject<ArrayList<String>>(lexemes);
                    Dic.normalizeLexicalEntry(res, this, tempRef_lexemes2);
                    lexemes = (ArrayList)tempRef_lexemes2.argvalue;
                    continue;
                }
                Gram grm22 = this.paradigms.get(flxname);
                if (grm22 == null) {
                    String res = forms[ires] + "," + lemma + ",";
                    res = outputs[ires].length() > 1 && outputs[ires].charAt(0) == '+' ? res + outputs[ires].substring(1) : res + outputs[ires];
                    RefObject<ArrayList<String>> tempRef_lexemes3 = new RefObject<ArrayList<String>>(lexemes);
                    Dic.normalizeLexicalEntry(res + this.combineAllFeatures(lexfeatures), this, tempRef_lexemes3);
                    lexemes = (ArrayList)tempRef_lexemes3.argvalue;
                    continue;
                }
                String[] forms2 = null;
                String[] outputs2 = null;
                RefObject<Object> tempRef_forms2 = new RefObject<Object>(forms2);
                RefObject<Object> tempRef_outputs2 = new RefObject<Object>(outputs2);
                grm22.inflect(this.Lan, forms[ires], tempRef_forms2, tempRef_outputs2, this.paradigms);
                forms2 = (String[])tempRef_forms2.argvalue;
                outputs2 = (String[])tempRef_outputs2.argvalue;
                if (forms2 == null) continue;
                for (int ires2 = 0; ires2 < forms2.length; ++ires2) {
                    String res = forms2[ires2] + "," + lemma + ",";
                    res = outputs[ires].length() > 1 && outputs[ires].charAt(0) == '+' ? res + outputs[ires].substring(1) : res + outputs[ires];
                    res = res + initialinfo.toString() + outputs2[ires2];
                    RefObject<ArrayList<String>> tempRef_lexemes4 = new RefObject<ArrayList<String>>(lexemes);
                    Dic.normalizeLexicalEntry(res + this.combineAllFeatures(lexfeatures), this, tempRef_lexemes4);
                    lexemes = (ArrayList)tempRef_lexemes4.argvalue;
                }
            }
        }
        return lexemes;
    }

    public final ArrayList<String> inflectSolutions(ArrayList<String> sols) {
        ParameterCheck.mandatory("sols", sols);
        ArrayList<String> results = new ArrayList<String>();
        ArrayList<String> lemmas = new ArrayList<String>();
        ArrayList<String> categories = new ArrayList<String>();
        ArrayList<String> paradigms = new ArrayList<String>();
        for (int isols = 0; isols < sols.size(); ++isols) {
            String[] myfeatures;
            String info;
            RefObject<Object> tempRef_info;
            String category;
            RefObject<Object> tempRef_category;
            String lemma;
            RefObject<Object> tempRef_lemma;
            String entry;
            RefObject<Object> tempRef_entry;
            String lex = sols.get(isols);
            boolean tempVar = !Dic.parseDELAF(lex, tempRef_entry = new RefObject<Object>((entry = null)), tempRef_lemma = new RefObject<Object>((lemma = null)), null, tempRef_category = new RefObject<Object>((category = null)), tempRef_info = new RefObject<Object>((info = null)), null);
            entry = (String)tempRef_entry.argvalue;
            lemma = (String)tempRef_lemma.argvalue;
            category = (String)tempRef_category.argvalue;
            info = (String)tempRef_info.argvalue;
            if (tempVar) continue;
            String myfeature = Dic.lookFor("FLX", info, null);
            if (myfeature != null) {
                Gram grm;
                String expname = myfeature.substring(new String("FLX=").length());
                int index = -1;
                for (int i = 0; i < lemmas.size(); ++i) {
                    if (!lemma.equals(lemmas.get(i)) || !category.equals(categories.get(i)) || !expname.equals(paradigms.get(i))) continue;
                    index = i;
                    break;
                }
                if (index != -1) continue;
                lemmas.add(lemma);
                categories.add(category);
                paradigms.add(expname);
                if (!this.paradigms.containsKey(expname) || (grm = this.paradigms.get(expname)) == null) continue;
                String[] forms = null;
                String[] outputs = null;
                RefObject<Object> tempRef_forms = new RefObject<Object>(forms);
                RefObject<Object> tempRef_outputs = new RefObject<Object>(outputs);
                grm.inflect(this.Lan, lemma, tempRef_forms, tempRef_outputs, this.paradigms);
                forms = (String[])tempRef_forms.argvalue;
                outputs = (String[])tempRef_outputs.argvalue;
                for (int ires = 0; ires < forms.length; ++ires) {
                    results.add(forms[ires]);
                    if (outputs[ires].length() > 1 && outputs[ires].charAt(0) == '+') {
                        results.add(outputs[ires].substring(1));
                        continue;
                    }
                    results.add(outputs[ires]);
                }
            }
            if ((myfeatures = Dic.lookForAll("DRV", info, null)) == null) continue;
            for (String mydrv : myfeatures) {
                Gram grm;
                String expname = null;
                String flxname = null;
                String expname0 = mydrv.substring(new String("DRV=").length());
                int icomb = expname0.indexOf(58);
                if (icomb != -1) {
                    expname = expname0.substring(0, icomb);
                    flxname = expname0.substring(icomb + 1);
                } else {
                    expname = expname0;
                    flxname = myfeature.substring(new String("FLX=").length());
                }
                if (!this.paradigms.containsKey(expname) || (grm = this.paradigms.get(expname)) == null) continue;
                String[] forms = null;
                String[] outputs = null;
                RefObject<Object> tempRef_forms2 = new RefObject<Object>(forms);
                RefObject<Object> tempRef_outputs2 = new RefObject<Object>(outputs);
                grm.inflect(this.Lan, entry, tempRef_forms2, tempRef_outputs2, this.paradigms);
                forms = (String[])tempRef_forms2.argvalue;
                outputs = (String[])tempRef_outputs2.argvalue;
                if (forms == null || forms.length == 0) continue;
                for (int ires = 0; ires < forms.length; ++ires) {
                    String initialinfo = Dic.removeFeature("NW", info);
                    int index = initialinfo.indexOf(43);
                    if (index != -1) {
                        initialinfo = initialinfo.substring(index);
                    }
                    String newinfo = outputs[ires].length() > 1 && outputs[ires].charAt(0) == '+' ? outputs[ires].substring(1) : outputs[ires];
                    if (flxname == null) {
                        results.add(forms[ires]);
                        results.add(newinfo);
                        continue;
                    }
                    Gram grm2 = this.paradigms.get(flxname);
                    if (grm2 == null) continue;
                    String[] dforms = null;
                    String[] doutputs = null;
                    RefObject<Object> tempRef_dforms = new RefObject<Object>(dforms);
                    RefObject<Object> tempRef_doutputs = new RefObject<Object>(doutputs);
                    grm2.inflect(this.Lan, forms[ires], tempRef_dforms, tempRef_doutputs, this.paradigms);
                    dforms = (String[])tempRef_dforms.argvalue;
                    doutputs = (String[])tempRef_doutputs.argvalue;
                    if (dforms == null || dforms.length == 0) continue;
                    for (int i2res = 0; i2res < dforms.length; ++i2res) {
                        String lastinfo = doutputs[i2res];
                        results.add(dforms[i2res]);
                        results.add(newinfo + lastinfo);
                    }
                }
            }
        }
        return results;
    }

    private void filterOutComplexInfos(ArrayList<String> sols) {
        int i = 0;
        while (i < sols.size()) {
            String entry = null;
            String info = null;
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_info = new RefObject<Object>(info);
            Dic.parseDELAS(sols.get(i), tempRef_entry, tempRef_info);
            entry = (String)tempRef_entry.argvalue;
            info = (String)tempRef_info.argvalue;
            if (this.isComplex(info, null)) {
                sols.subList(i, i + 1).clear();
                continue;
            }
            ++i;
        }
    }

    private String[] computeDerivations(String op, ArrayList<String> lexs, RefObject<Language> lan1) throws IOException, ClassNotFoundException {
        ParameterCheck.mandatoryString("op", op);
        ParameterCheck.mandatory("lexs", lexs);
        ParameterCheck.mandatory("lan1", lan1);
        String errmessage = null;
        lan1.argvalue = null;
        String[] finalres = null;
        if (lexs.isEmpty()) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (int ilex = 0; ilex < lexs.size(); ++ilex) {
            StringBuilder sb;
            String opfield;
            String oplanguage;
            String opconstraints;
            String op3;
            String entry = null;
            String lemma = null;
            String category = null;
            String[] features = null;
            RefObject<Object> tempRef_entry = new RefObject<Object>(entry);
            RefObject<Object> tempRef_lemma = new RefObject<Object>(lemma);
            RefObject<Object> tempRef_category = new RefObject<Object>(category);
            RefObject<Object> tempRef_features = new RefObject<Object>(features);
            boolean tempVar = !Dic.parseDELAF(lexs.get(ilex), tempRef_entry, tempRef_lemma, null, tempRef_category, null, tempRef_features);
            entry = (String)tempRef_entry.argvalue;
            lemma = (String)tempRef_lemma.argvalue;
            category = (String)tempRef_category.argvalue;
            features = (String[])tempRef_features.argvalue;
            if (tempVar) continue;
            if (op.equals("_")) {
                results.add(lemma);
                continue;
            }
            if (op.length() > 1 && op.charAt(0) == '_') {
                ArrayList<String> lexemes;
                if (!this.ResourcesLoaded) {
                    RefObject<Object> tempRef_errmessage = new RefObject<Object>(errmessage);
                    this.loadResources(this.preferences.ldic.get(this.Lan.isoName), null, false, tempRef_errmessage);
                    errmessage = (String)tempRef_errmessage.argvalue;
                }
                if ((lexemes = this.inflectAndDerive(entry, lemma, category, features)) == null || lexemes.size() == 0) {
                    errmessage = "Cannot derive " + lemma;
                    Dic.writeLog(errmessage);
                    continue;
                }
                for (String lexeme : lexemes) {
                    String[] listoffeatures;
                    RefObject<Object> tempRef_listoffeatures;
                    RefObject<String> tempRef_category2;
                    RefObject<String> tempRef_lemma2;
                    RefObject<String> tempRef_entry2;
                    boolean tempVar2 = !Dic.parseDELAF(lexeme, tempRef_entry2 = new RefObject<String>(entry), tempRef_lemma2 = new RefObject<String>(lemma), null, tempRef_category2 = new RefObject<String>(category), null, tempRef_listoffeatures = new RefObject<Object>((listoffeatures = null)));
                    entry = (String)tempRef_entry2.argvalue;
                    lemma = (String)tempRef_lemma2.argvalue;
                    category = (String)tempRef_category2.argvalue;
                    listoffeatures = (String[])tempRef_listoffeatures.argvalue;
                    if (tempVar2 || !this.lexInfoMatchOperator(category, listoffeatures, op.substring(1))) continue;
                    results.add(entry);
                }
                continue;
            }
            if (op.length() <= 1 || op.charAt(0) != '$') continue;
            String op2 = op.substring(1);
            int index1 = op2.indexOf(95);
            if (index1 == -1) {
                op3 = op2;
                opconstraints = null;
            } else {
                op3 = op2.substring(0, index1);
                opconstraints = op2.substring(index1 + 1);
            }
            int index2 = op3.indexOf(36);
            if (index2 == -1) {
                oplanguage = op3;
                opfield = null;
            } else {
                oplanguage = op3.substring(0, index2);
                opfield = op3.substring(index2 + 1);
            }
            if (oplanguage.equals("CAT")) {
                results.add(category);
                continue;
            }
            if (oplanguage.equals("ENT")) {
                results.add(entry);
                continue;
            }
            if (oplanguage.equals("ALLS")) {
                sb = new StringBuilder();
                if (features != null) {
                    for (int i = 0; i < features.length; ++i) {
                        String feat = features[i];
                        if (feat == null || feat.equals("")) {
                            System.out.println("a feature is empty???");
                            continue;
                        }
                        String propval = Dic.getPropertyValue(feat);
                        if (!this.isASyntacticFeature(propval) || propval.equals("NW") || propval.equals("FXC")) continue;
                        sb.append("+" + feat);
                    }
                }
                results.add(sb.toString());
                continue;
            }
            if (oplanguage.equals("ALLF")) {
                sb = new StringBuilder();
                if (features != null) {
                    for (int i = 0; i < features.length; ++i) {
                        String feat = features[i];
                        if (feat == null || feat.equals("")) {
                            System.out.println("a feature is empty???");
                            continue;
                        }
                        String propval = Dic.getPropertyValue(feat);
                        if (!this.isAninflectionalFeature(propval)) continue;
                        sb.append("+" + feat);
                    }
                }
                results.add(sb.toString());
                continue;
            }
            if (features == null) continue;
            ArrayList<String> myfeatures = new ArrayList<String>();
            for (String feat : features) {
                String propname = null;
                String propvalue = null;
                RefObject<Object> tempRef_propname = new RefObject<Object>(propname);
                RefObject<Object> tempRef_propvalue = new RefObject<Object>(propvalue);
                Dic.getPropertyNameValue(feat, tempRef_propname, tempRef_propvalue);
                propname = (String)tempRef_propname.argvalue;
                propvalue = (String)tempRef_propvalue.argvalue;
                if (!oplanguage.equals(propname)) continue;
                myfeatures.add(propvalue);
            }
            if (index1 == -1 && index2 == -1) {
                results.addAll(myfeatures);
                continue;
            }
            Language lan2 = null;
            if (oplanguage.length() == 2 && Character.isUpperCase(oplanguage.charAt(0)) && Character.isUpperCase(oplanguage.charAt(1))) {
                lan2 = new Language(oplanguage.toLowerCase());
                if (lan1.argvalue == null) {
                    lan1.argvalue = lan2;
                }
            }
            if (lan2 == null) {
                this.engine2 = this;
                lan2 = this.Lan;
            } else if (this.engine2 == null || !this.engine2.Lan.isoName.equals(lan2.isoName)) {
                RefObject<Language> tempRef_lan2 = new RefObject<Language>(lan2);
                this.engine2 = new Engine(tempRef_lan2, this.applicationDir, this.docDir, this.projectDir, this.projectMode, this.preferences, this.BackgroundWorking, this.backgroundWorker);
                lan2 = (Language)tempRef_lan2.argvalue;
                RefObject<String> tempRef_errmessage2 = new RefObject<String>(errmessage);
                this.engine2.loadResources(this.preferences.ldic.get(lan2.isoName), null, false, tempRef_errmessage2);
                errmessage = (String)tempRef_errmessage2.argvalue;
            } else {
                lan2 = this.engine2.Lan;
            }
            ArrayList<String> s_sols = null;
            for (String val : myfeatures) {
                ArrayList<String> lexs2;
                ArrayList<String> c_sols;
                if (!lan2.asianTokenizer && (s_sols = this.engine2.lookup(-1, val, true, null, 0, null)) != null) {
                    Engine.filterNonWords(s_sols);
                    this.filterUnamb(s_sols);
                }
                if ((c_sols = this.engine2.lookup(-1, val, false, val, 0, null)) != null && c_sols.size() > 0) {
                    Engine.filterNonWords(c_sols);
                    this.filterUnamb(c_sols);
                    lexs2 = new ArrayList<String>(c_sols);
                } else {
                    lexs2 = s_sols != null && s_sols.size() > 0 ? new ArrayList<String>(s_sols) : null;
                }
                if (lexs2 == null) {
                    errmessage = "Cannot find " + val + " in target language " + lan2.isoName;
                    Dic.writeLog(errmessage);
                    continue;
                }
                for (int ilex2 = 0; ilex2 < lexs2.size(); ilex2 += 2) {
                    RefObject<String[]> tempRef_features2;
                    RefObject<String> tempRef_category3;
                    RefObject<String> tempRef_lemma3;
                    RefObject<String> tempRef_entry3;
                    String lex = lexs2.get(ilex2);
                    boolean tempVar3 = !Dic.parseDELAF(lex, tempRef_entry3 = new RefObject<String>(entry), tempRef_lemma3 = new RefObject<String>(lemma), null, tempRef_category3 = new RefObject<String>(category), null, tempRef_features2 = new RefObject<String[]>(features));
                    entry = (String)tempRef_entry3.argvalue;
                    lemma = (String)tempRef_lemma3.argvalue;
                    category = (String)tempRef_category3.argvalue;
                    features = (String[])tempRef_features2.argvalue;
                    if (tempVar3) continue;
                    if (opfield != null) {
                        ArrayList<String> myfeatures2 = new ArrayList<String>();
                        if (features != null) {
                            for (String feat : features) {
                                String propname = null;
                                String propvalue = null;
                                RefObject<Object> tempRef_propname2 = new RefObject<Object>(propname);
                                RefObject<Object> tempRef_propvalue2 = new RefObject<Object>(propvalue);
                                Dic.getPropertyNameValue(feat, tempRef_propname2, tempRef_propvalue2);
                                propname = (String)tempRef_propname2.argvalue;
                                propvalue = (String)tempRef_propvalue2.argvalue;
                                if (!opfield.equals(propname)) continue;
                                myfeatures2.add(propvalue);
                            }
                        }
                        results.addAll(myfeatures2);
                        continue;
                    }
                    ArrayList<String> lexemes = this.engine2.inflectAndDerive(val, lemma, category, features);
                    if (lexemes == null || lexemes.isEmpty()) {
                        errmessage = "Cannot derive '" + val + "' in target language '" + lan2.isoName.toUpperCase() + "' to compute " + op;
                        Dic.writeLog(errmessage);
                        continue;
                    }
                    for (String lexeme : lexemes) {
                        String[] listoffeatures;
                        RefObject<Object> tempRef_listoffeatures2;
                        RefObject<String> tempRef_category4;
                        RefObject<String> tempRef_lemma4;
                        RefObject<String> tempRef_entry4;
                        boolean tempVar4 = !Dic.parseDELAF(lexeme, tempRef_entry4 = new RefObject<String>(entry), tempRef_lemma4 = new RefObject<String>(lemma), null, tempRef_category4 = new RefObject<String>(category), null, tempRef_listoffeatures2 = new RefObject<Object>((listoffeatures = null)));
                        entry = (String)tempRef_entry4.argvalue;
                        lemma = (String)tempRef_lemma4.argvalue;
                        category = (String)tempRef_category4.argvalue;
                        listoffeatures = (String[])tempRef_listoffeatures2.argvalue;
                        if (tempVar4 || !this.lexInfoMatchOperator(category, listoffeatures, opconstraints)) continue;
                        results.add(entry);
                    }
                }
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        for (int i = 0; i < results.size(); ++i) {
            String res = (String)results.get(i);
            int j = i + 1;
            while (j < results.size()) {
                String res2 = (String)results.get(j);
                if (res.equals(res2)) {
                    results.remove(j);
                    continue;
                }
                ++j;
            }
        }
        finalres = new String[results.size()];
        results.toArray(finalres);
        return finalres;
    }

    public final ArrayList<Object> mergeIntoAnnotations(String textbuffer, int tunb, double absolutebegaddress, double absoluteendaddress, ArrayList<Double> absaddresses, ArrayList<String> output, boolean keepLexemes) {
        ParameterCheck.mandatoryString("textbuffer", textbuffer);
        if (output == null || output.isEmpty() || absaddresses == null || absaddresses.isEmpty()) {
            return null;
        }
        ArrayList<Object> annotations = new ArrayList<Object>();
        StringBuilder sboutput = new StringBuilder();
        for (int iout = 0; iout < output.size(); ++iout) {
            if (output.get(iout) == null) continue;
            sboutput.append(output.get(iout));
        }
        String soutput = sboutput.toString();
        annotations.add(tunb);
        annotations.add(soutput);
        annotations.add(absolutebegaddress);
        annotations.add(absoluteendaddress);
        block1: for (int i = 0; i < output.size() && i < absaddresses.size(); ++i) {
            String out2;
            int j;
            int reclevel;
            double beg;
            String out1 = output.get(i);
            if (out1 == null || out1.equals("") || out1.charAt(0) != '<') continue;
            if (!keepLexemes) {
                beg = absaddresses.get(i);
                if (beg < (double)textbuffer.length() && beg > 0.0 && Character.isWhitespace(textbuffer.charAt((int)beg))) {
                    while (beg < (double)textbuffer.length() && Character.isWhitespace(textbuffer.charAt((int)beg))) {
                        beg += 1.0;
                    }
                }
                reclevel = 1;
                for (int iout1 = 1; iout1 < out1.length(); ++iout1) {
                    if (out1.charAt(iout1) == '>') {
                        --reclevel;
                        continue;
                    }
                    if (out1.charAt(iout1) != '<') continue;
                    ++reclevel;
                }
                if (reclevel == 0) {
                    annotations.add(beg);
                    annotations.add(out1);
                    annotations.add(beg);
                    continue;
                }
                reclevel = 1;
                String outputannotation = out1.substring(1);
                for (j = i + 1; j < output.size() && j < absaddresses.size(); ++j) {
                    out2 = output.get(j);
                    if (out2 == null || out2.equals("")) continue;
                    if (out2.charAt(0) == '<') {
                        ++reclevel;
                    }
                    if (out2.charAt(out2.length() - 1) == '>') {
                        if (--reclevel != 0) continue;
                        annotations.add(beg);
                        outputannotation = outputannotation + out2.substring(0, out2.length() - 1);
                        annotations.add(outputannotation);
                        annotations.add((double)absaddresses.get(j));
                        continue block1;
                    }
                    if (reclevel != 1) continue;
                    outputannotation = outputannotation + out2;
                }
                continue;
            }
            beg = absaddresses.get(i);
            if (beg < (double)textbuffer.length() && beg > 0.0 && Character.isWhitespace(textbuffer.charAt((int)beg))) {
                while (beg < (double)textbuffer.length() && Character.isWhitespace(textbuffer.charAt((int)beg))) {
                    beg += 1.0;
                }
            }
            out1 = out1.substring(0, out1.length() - 1);
            reclevel = 1;
            for (int iout1 = 1; iout1 < out1.length(); ++iout1) {
                if (out1.charAt(iout1) == '>') {
                    --reclevel;
                    continue;
                }
                if (out1.charAt(iout1) != '<') continue;
                ++reclevel;
            }
            if (reclevel == 0) {
                annotations.add(beg);
                annotations.add(out1);
                annotations.add(beg);
                continue;
            }
            reclevel = 1;
            String outputannotation = out1.substring(1);
            for (j = i + 1; j < output.size() && j < absaddresses.size(); ++j) {
                out2 = output.get(j);
                if ((out2 = out2.substring(0, out2.length() - 1)) == null || out2.equals("")) continue;
                if (out2.charAt(0) == '<') {
                    if (out2.charAt(out2.length() - 1) == '>') continue;
                    ++reclevel;
                    continue;
                }
                if (out2.charAt(0) == '>') {
                    if (--reclevel != 0) continue;
                    annotations.add(beg);
                    outputannotation = outputannotation + out2.substring(0, out2.length() - 1);
                    annotations.add(outputannotation);
                    annotations.add((double)absaddresses.get(j));
                    continue block1;
                }
                if (reclevel != 1 || out2.charAt(0) == ':') continue;
                outputannotation = outputannotation + out2;
            }
        }
        return annotations;
    }
}

